/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import java.math.MathContext;
import java.util.Calendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.tariff.level.DeviceLevelManager;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxManager;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.TrafficRangeManager;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.sql.ConnectionSet;

public class InetTariffContext
extends TariffContext {
    static final Logger logger = LogManager.getLogger();
    public final InetOptionRuntimeMap inetOptionRuntimeMap;
    public TrafficMaxManager maxTrafficManager;
    public final InetDeviceMap deviceMap;
    private DeviceLevelManager levelManager;

    public InetTariffContext(DefaultServerSetup setup, ConnectionSet connectionSet, int moduleId, MathContext mc, Calendar fromTime, boolean realtime) throws BGException {
        super(MathContext.DECIMAL64, fromTime.getTime(), realtime, moduleId);
        this.maxTrafficManager = new TrafficMaxManager(moduleId, realtime);
        this.inetOptionRuntimeMap = InetOptionRuntimeMap.getInstance(connectionSet, moduleId);
        this.deviceMap = InetDeviceMap.getInstance(moduleId);
        this.levelManager = new DeviceLevelManager(moduleId, realtime);
    }

    public DeviceLevelManager getLevelManager() {
        return this.levelManager;
    }

    protected void initTrafficRangeManager(int moduleId, boolean realtime) throws BGException {
        this.rangedTrafficManager = new TrafficRangeManager(moduleId, realtime);
    }
}

