/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.action;

import bitel.billing.server.admin.resource.action.base.ActionBase;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRangeUse;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNResourceManager;
import ru.bitel.common.TimeUtils;

public class ActionIPResourceUseHistory
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int resourceId = this.getIntParameter("resource_id", 0);
        int itemId = this.getIntParameter("item_id", 0);
        long ip1 = this.getLongParameter("ip1", 0L);
        long ip2 = this.getLongParameter("ip2", 0L);
        if (this.mid <= 0 || resourceId <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        List resourceUseList = new IPNResourceManager(this.con, this.mid).getResourceUse(resourceId, itemId, ip1, ip2);
        for (IPResourceRangeUse ruse : resourceUseList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("cid", String.valueOf(ruse.getContractId()));
            row.setAttribute("contract", ruse.getContractTitle());
            row.setAttribute("contract_comment", ruse.getContractComment());
            row.setAttribute("period", TimeUtils.formatPeriod((Date)ruse.getDateFrom(), (Date)ruse.getDateTo()));
            row.setAttribute("ip_range", IPUtils.convertLongIpToString((long)ruse.getIp1()) + "-" + IPUtils.convertLongIpToString((long)ruse.getIp2()));
        }
    }
}

