/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.client.utils;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGSelectFilePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.bgbilling.kernel.contract.loader.client.UtilPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class UpdateBalancePanel
extends UtilPanel {
    public static final String TITLE = "\u0418\u043c\u043f\u043e\u0440\u0442 \u0431\u0430\u043b\u0430\u043d\u0441\u0430";
    public static final String CARD_NAME = "updateBalance";
    private BGTextField comment = null;
    private BGControlPanelDateNoB controlPanelDate = null;
    private BGComboBox<IdTitle> chargeTypeComboBox = null;
    private BGComboBox<IdTitle> paymentTypeComboBox = null;
    private UtilPanel.PanelContractParameter contractParameter = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private String data = null;

    protected void jbInit() throws Exception {
        this.comment = new BGTextField(80);
        this.chargeTypeComboBox = new BGComboBox();
        this.paymentTypeComboBox = new BGComboBox();
        this.controlPanelDate = new BGControlPanelDateNoB();
        this.setLayout(new GridBagLayout());
        this.add(new UtilPanel.PanelTitleLabel(TITLE), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(this.getSourceTabPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(this.getDatePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(this.getComboBoxPanel("\u0422\u0438\u043f \u041f\u0440\u0438\u0445\u043e\u0434\u0430: ", this.paymentTypeComboBox), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(this.getComboBoxPanel("\u0422\u0438\u043f \u0420\u0430\u0441\u0445\u043e\u0434\u0430: ", this.chargeTypeComboBox), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(this.getCommentPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JTabbedPane getSourceTabPanel() {
        this.contractParameter = this.getContractParameterPanel(null, new int[]{EntitySpecAttrType.TEXT.getCode()});
        final BGSelectFilePanel selectFilePanel = new BGSelectFilePanel();
        selectFilePanel.setDialogTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
        selectFilePanel.setShowPath(true);
        selectFilePanel.setFileFieldBackground(new JTextField().getBackground());
        selectFilePanel.setFileFilter("csv", "Text CSV");
        selectFilePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Path path;
                File file;
                if ("fileSelected".equals(propertyChangeEvent.getPropertyName()) && (file = selectFilePanel.getSelectedFile()) != null && Files.exists(path = file.toPath(), new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        UpdateBalancePanel.this.data = Files.readString(path);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
        JPanel filePanel = new JPanel(new GridBagLayout());
        filePanel.setBorder((Border)new BGTitleBorder("\u0424\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438"));
        filePanel.add((Component)selectFilePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        filePanel.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442 \u0437\u0430\u043f\u0438\u0441\u0435\u0439: \u041d\u041e\u041c\u0415\u0420_\u0414\u041e\u0413\u041e\u0412\u041e\u0420\u0410<TAB>\u0421\u0423\u041c\u041c\u0410, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 B0885-21  -123.45"), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.tabbedPane.add((Component)this.contractParameter, "\u0418\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.tabbedPane.add((Component)filePanel, "\u0418\u0437 \u0444\u0430\u0439\u043b\u0430");
        return this.tabbedPane;
    }

    private JPanel getDatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 (\u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u043c\u0435\u0441\u044f\u0446 \u0438 \u0433\u043e\u0434), \u0431\u0430\u043b\u0430\u043d\u0441 \u043d\u0430 1 \u0447\u0438\u0441\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        panel.add((Component)this.controlPanelDate, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 5), 0, 0));
        return panel;
    }

    private JPanel getCommentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u043f\u043b\u0430\u0442\u0435\u0436\u0430(\u0440\u0430\u0441\u0445\u043e\u0434\u0430):"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        panel.add((Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 2, 5), 0, 0));
        return panel;
    }

    private JPanel getComboBoxPanel(String title, BGComboBox<IdTitle> comboBox) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        panel.add((Component)comboBox, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 5), 0, 0));
        return panel;
    }

    @Override
    protected void doUtil() {
        JSONObject config = new JSONObject();
        if (this.tabbedPane.getSelectedIndex() == 0) {
            IdTitle parameterId = (IdTitle)this.contractParameter.getList().getSelectedValue();
            if (parameterId == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
                return;
            }
            config.put("parameterId", parameterId.getId());
        } else if (Utils.isBlankString((String)this.data)) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438");
            return;
        }
        String date = this.controlPanelDate.getDateString();
        if (Utils.isBlankString((String)date)) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
            return;
        }
        config.put("date", (Object)date);
        IdTitle paymentTypeId = (IdTitle)this.paymentTypeComboBox.getSelectedItem();
        if (paymentTypeId == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0422\u0438\u043f \u043f\u0440\u0438\u0445\u043e\u0434\u0430");
            return;
        }
        config.put("paymentTypeId", paymentTypeId.getId());
        IdTitle chargeTypeId = (IdTitle)this.chargeTypeComboBox.getSelectedItem();
        if (chargeTypeId == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430");
            return;
        }
        config.put("chargeTypeId", chargeTypeId.getId());
        config.put("comment", (Object)this.comment.getText());
        try {
            this.getLoaderService().doUtil("ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBalanceUpdateUtil", this.data, config.toString());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    @Override
    protected void doClearForm() {
        this.contractParameter.getList().clearSelection();
        this.controlPanelDate.setLocalDate(null);
        this.chargeTypeComboBox.setSelectedIndex(-1);
        this.paymentTypeComboBox.setSelectedIndex(-1);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.paymentTypeComboBox.removeAllItems();
            ((PaymentService)((ClientContext)this.getContext()).getPort(PaymentService.class)).paymentTypeList(null, 0).forEach(i -> this.paymentTypeComboBox.addItem((Object)new IdTitle(i.getId(), i.getTitle())));
            this.chargeTypeComboBox.removeAllItems();
            ((ChargeService)((ClientContext)this.getContext()).getPort(ChargeService.class)).chargeTypeList(null, 0, false).forEach(i -> this.chargeTypeComboBox.addItem((Object)new IdTitle(i.getId(), i.getTitle())));
            this.doClearForm();
        });
    }
}

