/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrServicingPerson;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

public class EntityAttrServicingPersonDao
extends EntityAttrDefaultDao<EntityAttrServicingPerson> {
    public EntityAttrServicingPersonDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String table) {
        super(con, entityAttrDao, table);
    }

    @Override
    protected void createTable() {
    }

    @Override
    protected boolean updateImpl(int entityId, EntityAttrServicingPerson entityAttrServicingPerson) throws SQLException, BGException {
        this.insert(entityId, (EntityAttr)entityAttrServicingPerson);
        return true;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException, BGException {
        EntityAttrServicingPerson attrServicingPerson = (EntityAttrServicingPerson)a;
        int cid = attrServicingPerson.getEntityId();
        int pid = attrServicingPerson.getEntitySpecAttrId();
        Map value = ((EntityAttrServicingPerson)a).getValue();
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM contract_parameter_type_4 WHERE cid=? AND pid=?");){
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ps.executeUpdate();
        }
        ps = this.con.prepareStatement("INSERT INTO contract_parameter_type_4 VALUES ( ?, ?, ?, ? )");
        try {
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            for (Integer servicePersonId : value.keySet()) {
                for (Integer addressAttrId : (List)value.get(servicePersonId)) {
                    ps.setInt(3, addressAttrId);
                    ps.setInt(4, servicePersonId);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    @Override
    public EntityAttrServicingPerson get(int entityId, int attrSpecId) throws BGException {
        EntityAttrServicingPerson result = new EntityAttrServicingPerson();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.table + " WHERE cid=? AND pid=?");){
            ps.setInt(1, entityId);
            ps.setInt(2, attrSpecId);
            result.setEntityId(entityId);
            result.setEntitySpecAttrId(attrSpecId);
            HashMap value = new HashMap();
            result.setValue(value);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int attrAddressId = rs.getInt(3);
                int servicePersonId = rs.getInt(4);
                ((List)value.getOrDefault(servicePersonId, new ArrayList())).add(attrAddressId);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

