/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGFileChooser
extends JFileChooser {
    private Component _parent;

    public BGFileChooser(Component parent) {
        this._parent = parent;
        super.setCurrentDirectory(this.loadCurrentDirectory());
        UIManager.put("FileChooser.openButtonText", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        UIManager.put("FileChooser.saveButtonText", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        UIManager.put("FileChooser.cancelButtonText", "\u041e\u0442\u043c\u0435\u043d\u0430");
        UIManager.put("FileChooser.fileNameLabelText", "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430");
        UIManager.put("FileChooser.filesOfTypeLabelText", "\u0422\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432");
        UIManager.put("FileChooser.lookInLabelText", "\u041f\u0430\u043f\u043a\u0430");
        UIManager.put("FileChooser.saveInLabelText", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 \u043f\u0430\u043f\u043a\u0435");
        UIManager.put("FileChooser.folderNameLabelText", "\u041f\u0443\u0442\u044c \u043f\u0430\u043f\u043a\u0438");
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        super.setCurrentDirectory(this.loadCurrentDirectory());
    }

    public int showSaveDialog() {
        return super.showSaveDialog(this._parent);
    }

    public int showOpenDialog() {
        return super.showOpenDialog(this._parent);
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        int returnValue = super.showDialog(parent, approveButtonText);
        if (returnValue == 0) {
            this.saveCurrentDirectory(this.getCurrentDirectory());
        }
        return returnValue;
    }

    private String getPanelKey() {
        return (this.getName() != null ? this.getName() : "BGFileChooser") + ":" + ClientUtils.getComponentKey(this._parent, "file.currentDir");
    }

    private File loadCurrentDirectory() {
        File dir = null;
        String currentDirectoryPath = ClientSetup.getInstance().getUserConfig().get(this.getPanelKey(), null);
        if (currentDirectoryPath != null) {
            dir = new File(currentDirectoryPath);
        }
        return dir;
    }

    private void saveCurrentDirectory(File dir) {
        ClientSetup.getInstance().getUserConfig().set(this.getPanelKey(), dir.getAbsolutePath());
    }
}

