/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.component.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;

public class ComponentEditor
extends BGTabPanel {
    public static final String TAB_ID = "components";
    private InstalledComponentTableModel installedTableModel = new InstalledComponentTableModel();
    private ModuleService moduleService = null;
    private JPopupMenu popupMenu = null;

    public ComponentEditor() {
        super(TAB_ID, "\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        this.jbInit();
        this.setData();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getInstalledComponentPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
    }

    private JPanel getInstalledComponentPanel() {
        final BGUTable table = new BGUTable(this.installedTableModel);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && table.pointOnSelectRows(e.getPoint())) {
                    ComponentEditor.this.getPopupMenu().show(table, e.getX(), e.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b"));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("refresh".equals(actionCommand)) {
            this.setData();
        } else if ("newItem".equals(actionCommand)) {
            new ComponentInstallDialog("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432", "").open();
        } else if ("editItem".equals(actionCommand)) {
            ClientUtils.showMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        } else if ("deleteItem".equals(actionCommand)) {
            this.componentDelete();
        }
    }

    @Override
    public void setData() {
        try {
            ArrayList<BGInstalledModule> data = new ArrayList<BGInstalledModule>();
            data.addAll(this.getModuleService().installedModuleList());
            data.addAll(this.getModuleService().installedPluginList());
            this.installedTableModel.setData(data);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private ModuleService getModuleService() {
        if (this.moduleService == null) {
            this.moduleService = this.getContext().getPort(ModuleService.class, 0);
        }
        return this.moduleService;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem deleteComponentMenuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442(\u044b)");
            deleteComponentMenuItem.addActionListener(e -> this.componentDelete());
            this.popupMenu.add(deleteComponentMenuItem);
            JMenuItem reinstallComponentMenuItem = new JMenuItem("\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442(\u044b)");
            reinstallComponentMenuItem.addActionListener(e -> this.componentReinstall());
            this.popupMenu.add(reinstallComponentMenuItem);
        }
        return this.popupMenu;
    }

    private void componentReinstall() {
        for (BGInstalledModule installedModule : this.installedTableModel.getSelectedRows()) {
            if (!ClientUtils.confirm(String.format("\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 - %s", installedModule.getTitle()), "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438")) continue;
            try {
                this.getModuleService().componentReinstall(installedModule.getId());
                ClientUtils.showMessageDialog("\u0414\u043b\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private void componentDelete() {
        for (BGInstalledModule installedModule : this.installedTableModel.getSelectedRows()) {
            if (!ClientUtils.confirmDelete(installedModule.getTitle())) continue;
            try {
                this.getModuleService().componentUninstall(installedModule.getName());
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        this.setData();
    }

    class InstalledComponentTableModel
    extends BGTableModel<BGInstalledModule> {
        public InstalledComponentTableModel() {
            super(InstalledComponentTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f", 100, 100, 100, "type", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 150, 150, "status", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0418\u043c\u044f", 200, 250, 300, "name", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 100, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0430\u043a\u0435\u0442 (\u043a\u043b\u0438\u0435\u043d\u0442)", 100, 100, -1, "packageClient", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0430\u043a\u0435\u0442 (\u0441\u0435\u0440\u0432\u0435\u0440)", 100, 100, -1, "packageServer", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(BGInstalledModule val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("status".equals(identifier)) {
                return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
            }
            return super.getValue(val, column);
        }
    }

    class ComponentInstallDialog
    extends BGEditorDialog<String> {
        private BGUList<KeyValue> selectedComponent;
        private BGUList<KeyValue> availableComponent;
        private JTextArea data;

        public ComponentInstallDialog(String title, String data) {
            super(title, data);
            this.selectedComponent = new BGUList();
            this.availableComponent = new BGUList();
            this.data = new JTextArea(30, 40);
        }

        @Override
        public void doDialogPanel() {
            try {
                ArrayList data = new ArrayList();
                ComponentEditor.this.getModuleService().componentAvailable().forEach(l -> {
                    String[] keyValues = l.split("\t");
                    String name = null;
                    String zipName = null;
                    String type = null;
                    for (int index = 0; index < keyValues.length; ++index) {
                        if (keyValues[index].startsWith("type:")) {
                            type = keyValues[index].substring(5);
                            if (!"app".equals(type)) continue;
                            return;
                        }
                        if (keyValues[index].startsWith("name:")) {
                            name = keyValues[index].substring(5);
                            continue;
                        }
                        if (!keyValues[index].startsWith("zipName:")) continue;
                        zipName = keyValues[index].substring(8);
                    }
                    if (name != null) {
                        data.add(new KeyValue(zipName, "[" + type + "] " + name));
                    }
                });
                this.availableComponent.setData(data);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
            this.panel.add((Component)this.getSelectedComponentPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getManageButtonPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 3, 0, 3), 0, 0));
            this.panel.add((Component)this.getAvailableComponentPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getComponentInfoPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        }

        private JPanel getSelectedComponentPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getJScrollPane(this.selectedComponent), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getManageButtonPanel() {
            JButton aButton = new JButton("<<<");
            aButton.addActionListener(e -> this.componentMove(this.availableComponent, this.selectedComponent));
            JButton dButton = new JButton(">>>");
            dButton.addActionListener(e -> this.componentMove(this.selectedComponent, this.availableComponent));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)aButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)dButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getAvailableComponentPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getJScrollPane(this.availableComponent), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getComponentInfoPanel() {
            this.data.setMargin(new Insets(3, 3, 3, 3));
            this.data.setLineWrap(true);
            this.data.setWrapStyleWord(true);
            this.data.setEditable(false);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(this.data), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private void componentMove(BGUList<KeyValue> from, BGUList<KeyValue> to) {
            for (KeyValue keyValue : from.getSelectedValuesList()) {
                ((DefaultListModel)to.getModel()).addElement(keyValue);
                ((DefaultListModel)from.getModel()).removeElement(keyValue);
            }
        }

        private JScrollPane getJScrollPane(Component component) {
            Dimension dimension = new Dimension(350, 300);
            JScrollPane scrollPane = new JScrollPane(component);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            return scrollPane;
        }

        @Override
        public boolean doApply() throws Exception {
            ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
            for (int index = 0; index < ((DefaultListModel)this.selectedComponent.getModel()).getSize(); ++index) {
                keyValues.add((KeyValue)((DefaultListModel)this.selectedComponent.getModel()).getElementAt(index));
            }
            if (keyValues.isEmpty()) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b");
                return false;
            }
            for (KeyValue keyValue : keyValues) {
                ComponentEditor.this.getModuleService().componentInstall(keyValue.getKey());
            }
            return true;
        }
    }
}

