/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.converters.BGConverter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class TVProductsContractGroupsToLabels
implements BGConverter {
    private static final Logger logger = LogManager.getLogger();
    private static final String PRODUCT_TABLE_NAME = "inv_product_spec";

    @Override
    public void runConverter(Connection connection) {
        if (!ServerUtils.tableExists((Connection)connection, (String)PRODUCT_TABLE_NAME)) {
            return;
        }
        this.convertGroupsToLabels(connection);
        this.convertHideForWebContractGroupsToLabels(connection);
    }

    private void convertGroupsToLabels(Connection connection) {
        HashMap<Integer, Long> productsWithGroups = new HashMap<Integer, Long>();
        String query = "SELECT id, contractGroups FROM inv_product_spec WHERE contractGroups>0";
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                productsWithGroups.put(rs.getInt("id"), rs.getLong("contractGroups"));
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage());
        }
        if (productsWithGroups.size() == 0) {
            return;
        }
        query = "UPDATE inv_product_spec SET contractGroups=0, contractLabels=? WHERE id=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            productsWithGroups.forEach((productId, groups) -> {
                try {
                    List ids = Utils.toIntegerList(Utils.maskToEnum(groups)).stream().mapToInt(x -> x + 2).boxed().collect(Collectors.toList());
                    ps.setString(1, Utils.toString(ids));
                    ps.setInt(2, (int)productId);
                    ps.addBatch();
                }
                catch (SQLException e) {
                    logger.error(e.getLocalizedMessage());
                }
            });
            ps.executeBatch();
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage());
        }
    }

    private void convertHideForWebContractGroupsToLabels(Connection connection) {
        HashMap<Integer, Long> productsWithGroups = new HashMap<Integer, Long>();
        String query = "SELECT id, hideForContractGroups FROM inv_product_spec WHERE hideForContractGroups>0";
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                productsWithGroups.put(rs.getInt("id"), rs.getLong("hideForContractGroups"));
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage());
        }
        if (productsWithGroups.size() == 0) {
            return;
        }
        query = "UPDATE inv_product_spec SET hideForContractGroups=0, hideForContractLabels=? WHERE id=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            productsWithGroups.forEach((productId, groups) -> {
                try {
                    List ids = Utils.toIntegerList(Utils.maskToEnum(groups)).stream().mapToInt(x -> x + 2).boxed().collect(Collectors.toList());
                    ps.setString(1, Utils.toString(ids));
                    ps.setInt(2, (int)productId);
                    ps.addBatch();
                }
                catch (SQLException e) {
                    logger.error(e.getLocalizedMessage());
                }
            });
            ps.executeBatch();
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage());
        }
    }
}

