/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentInfo;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class PaymentInfoDao
extends AbstractIdDao<PaymentInfo> {
    public PaymentInfoDao(Connection con) {
        super(con, -1, "payment_info");
    }

    @Override
    protected PaymentInfo getFromRS(ResultSet rs) throws SQLException, BGException {
        PaymentInfo paymentInfo = new PaymentInfo(rs.getInt("id"), rs.getInt("payment_id"));
        HashMap<String, String> info = new HashMap<String, String>();
        while (rs.next()) {
            info.put(rs.getString("key"), rs.getString("value"));
        }
        paymentInfo.setInfo(info);
        return paymentInfo;
    }

    @Override
    protected void updateImpl(PaymentInfo paymentInfo) throws BGException, SQLException {
        String prefix = paymentInfo.getId() > 0 ? "UPDATE " : "INSERT INTO ";
        String set = " SET payment_id=?, `key`=?, value=?";
        String query = prefix + this.tableName + set;
        if (paymentInfo.getId() > 0) {
            query = query + " WHERE id=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int paymentId = paymentInfo.getPaymentId();
            Map<String, String> info = paymentInfo.getInfo();
            for (String key : info.keySet()) {
                ps.setInt(1, paymentId);
                ps.setString(2, key);
                ps.setString(3, info.get(key));
                if (paymentInfo.getId() > 0) {
                    ps.setInt(4, paymentInfo.getId());
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    public PaymentInfo getInfoByPaymentId(int paymentId) throws BGException {
        PaymentInfo result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE payment_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, paymentId);
            result = this.getFromRS(ps.executeQuery());
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public List<PaymentInfo> getInfoByPaymentIds(int ... paymentIds) throws BGException {
        return this.getInfoByPaymentIds(Arrays.stream(paymentIds).boxed().collect(Collectors.toList()));
    }

    public List<PaymentInfo> getInfoByPaymentIds(List<Integer> paymentIds) throws BGException {
        ArrayList<PaymentInfo> result = new ArrayList<PaymentInfo>();
        if (Utils.isEmptyCollection(paymentIds)) {
            return result;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE payment_id IN (" + Utils.toString(paymentIds) + ")";
        try (Statement st = this.con.createStatement();){
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }
}

