/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.common.templates.CustomTemplate;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class CustomTemplateDao
extends AbstractIdDao<CustomTemplate> {
    private Connection con;

    public CustomTemplateDao(Connection con) {
        super(con, -1, "script_custom_template");
        this.con = con;
    }

    @Override
    protected void updateImpl(CustomTemplate template) throws BGException, SQLException {
        String set = " SET title=?, date_last_mod=NOW(), user_id=?, template_data=?, comment=?, extension=?";
        String query = template.getId() <= 0 ? "INSERT INTO " + this.tableName + set + ", create_date=NOW()" : "UPDATE " + this.tableName + set + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, template.getTitle());
            ps.setInt(index++, template.getUserId());
            ps.setString(index++, template.getTemplateData());
            ps.setString(index++, template.getComment());
            ps.setString(index++, template.getExtension());
            if (template.getId() > 0) {
                ps.setInt(index++, template.getId());
            }
            ps.executeUpdate();
            if (template.getId() <= 0) {
                template.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void getList(SearchResult<CustomTemplate> searchResult) throws BGException {
        List<CustomTemplate> result = searchResult.getList();
        if (result == null) {
            result = new ArrayList<CustomTemplate>();
        }
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName;
        if (page != null) {
            query = query + page.sqlLimit();
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    protected CustomTemplate getFromRS(ResultSet resultSet) throws SQLException {
        CustomTemplate template = new CustomTemplate();
        template.setId(resultSet.getInt("id"));
        template.setTitle(resultSet.getString("title"));
        template.setCreateDate(TimeUtils.convertTimestampToDate(resultSet.getTimestamp("create_date")));
        template.setLastModificationDate(TimeUtils.convertTimestampToDate(resultSet.getTimestamp("date_last_mod")));
        template.setUserId(resultSet.getInt("user_id"));
        template.setTemplateData(resultSet.getString("template_data"));
        template.setComment(resultSet.getString("comment"));
        template.setExtension(resultSet.getString("extension"));
        return template;
    }
}

