/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.table;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.beanutils.ConvertUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.AbstractBGTableModel;
import ru.bitel.common.client.table.BGTableModelColumn;

public abstract class AbstractBGTableModelXML
extends AbstractBGTableModel {
    private XPathFactory xPathFactory;
    private final Map<String, XPathExpression> xPathCache = new HashMap<String, XPathExpression>();
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    List<Col> columns = new ArrayList<Col>();
    List<Element> rows = new ArrayList<Element>();
    private static final Pattern patternComma = Pattern.compile("\\s*,\\s*");

    private FieldResolver getResolver(final Class<?> clazz) {
        if (clazz.equals(Object.class) || clazz.equals(String.class)) {
            return new FieldResolver(){

                @Override
                public Object getValue(String val) {
                    return val;
                }
            };
        }
        if (clazz.equals(BigDecimal.class)) {
            return new FieldResolver(){

                @Override
                public Object getValue(String val) {
                    return Utils.parseBigDecimal(val, BigDecimal.ZERO);
                }
            };
        }
        if (clazz.equals(Integer.class)) {
            return new FieldResolver(){

                @Override
                public Object getValue(String val) {
                    return Utils.parseInt(val);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            return new FieldResolver(){

                @Override
                public Object getValue(String val) {
                    return Utils.parseLong(val);
                }
            };
        }
        if (clazz.equals(Float.class)) {
            return new FieldResolver(){

                @Override
                public Object getValue(String val) {
                    return Float.valueOf(Utils.parseFloat(val, 0.0f));
                }
            };
        }
        if (clazz.equals(Double.class)) {
            return new FieldResolver(){

                @Override
                public Object getValue(String val) {
                    return Float.valueOf(Utils.parseFloat(val, 0.0f));
                }
            };
        }
        if (clazz.equals(Date.class)) {
            return new FieldResolver(){

                @Override
                public Object getValue(String val) {
                    return TimeUtils.parseDate(val, AbstractBGTableModelXML.this.dateFormat);
                }
            };
        }
        if (clazz.equals(Calendar.class)) {
            return new FieldResolver(){

                @Override
                public Object getValue(String val) {
                    return TimeUtils.parseCalendar(val, AbstractBGTableModelXML.this.dateFormat);
                }
            };
        }
        return new FieldResolver(){

            @Override
            public Object getValue(String val) {
                return ConvertUtils.convert((String)val.trim(), (Class)clazz);
            }
        };
    }

    private XPathFactory getXPathFactory() {
        if (this.xPathFactory == null) {
            this.xPathFactory = XPathFactory.newInstance();
        }
        return this.xPathFactory;
    }

    private Node selectNode(Element element, String expression) throws XPathExpressionException {
        Node node = null;
        XPathExpression xPathExpression = this.xPathCache.get(expression);
        if (xPathExpression == null) {
            xPathExpression = this.getXPathFactory().newXPath().compile(expression);
            this.xPathCache.put(expression, xPathExpression);
            node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
        }
        return node;
    }

    private String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuilder result = new StringBuilder();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() != 5 || (value = this.getText(subnode)) == null) continue;
            result.append(value);
        }
        return result.toString();
    }

    public AbstractBGTableModelXML(Node moduleDoc, String baseName, String id) {
        this(moduleDoc, baseName != null ? ResourceBundle.getBundle(baseName) : null, id);
    }

    public AbstractBGTableModelXML(Node moduleDoc, ResourceBundle rb, String tableId) {
        super(tableId);
        Element table;
        if (rb != null && moduleDoc != null && tableId != null && (table = XMLUtils.selectElement(moduleDoc, "/module/tables/table[@id='" + tableId + "']")) != null) {
            for (Node node = table.getFirstChild(); node != null; node = node.getNextSibling()) {
                Class clazz;
                int maxWidth;
                int prefferedWidth;
                int minWidth;
                String title;
                if (node.getNodeType() != 1) continue;
                Element col = (Element)node;
                String id = col.getAttribute("id");
                try {
                    title = rb.getString("table." + tableId + ".column." + id + ".title");
                }
                catch (Exception ex) {
                    title = "?";
                }
                String widthProto = col.getAttribute("width");
                String[] widthProtos = patternComma.split(widthProto);
                if (widthProtos.length > 2) {
                    minWidth = Utils.parseInt(widthProtos[0]);
                    prefferedWidth = Utils.parseInt(widthProtos[1]);
                    maxWidth = Utils.parseInt(widthProtos[2]);
                } else {
                    minWidth = -1;
                    prefferedWidth = Utils.parseInt(widthProtos[0]);
                    maxWidth = -1;
                }
                String editableValue = col.getAttribute("editable");
                String sortableValue = col.getAttribute("sortable");
                String className = col.getAttribute("class");
                String select = col.getAttribute("select");
                if (className.length() > 0) {
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        clazz = Object.class;
                        e.printStackTrace();
                    }
                } else {
                    clazz = Object.class;
                }
                if (select != null && select.length() > 0) {
                    this.columns.add(new ExpCol(id, select, title, clazz, minWidth, prefferedWidth, maxWidth, "yes".equals(editableValue), "yes".equals(sortableValue)));
                    continue;
                }
                this.columns.add(new Col(id, title, clazz, minWidth, prefferedWidth, maxWidth, "yes".equals(editableValue), "yes".equals(sortableValue)));
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get((int)columnIndex).clazz;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get((int)column).title;
    }

    @Override
    public boolean isColumnSortable(int column) {
        return this.columns.get((int)column).sortable;
    }

    @Override
    public int getColumnPrefferedWidth(int column) {
        return this.columns.get((int)column).prefferedWidth;
    }

    @Override
    public int getColumnMinWidth(int column) {
        return this.columns.get((int)column).minWidth;
    }

    @Override
    public int getColumnMaxWidth(int column) {
        return this.columns.get((int)column).maxWidth;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).getValue(this.rows.get(rowIndex));
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.columns.get(columnIndex).setValue(this.rows.get(rowIndex), value);
    }

    private class ExpCol
    extends Col {
        final String expression;

        public ExpCol(String name, String expression, String title, Class<?> clazz, int minWidth, int prefferedWidth, int maxWidth, boolean editable, boolean sortable) {
            super(name, title, clazz, minWidth, prefferedWidth, maxWidth, editable, sortable);
            this.expression = expression;
        }

        @Override
        public Object getValue(Element e) {
            Node node = null;
            try {
                node = AbstractBGTableModelXML.this.selectNode(e, this.expression);
            }
            catch (XPathExpressionException ex) {
                throw new RuntimeException("XPath selection failed. Expression: " + this.name, ex);
            }
            if (node != null) {
                return this.resolver.getValue(AbstractBGTableModelXML.this.getText(node));
            }
            return this.resolver.getValue("");
        }
    }

    class Col
    extends BGTableModelColumn<Element> {
        final FieldResolver resolver;

        public Col(String name, String title, Class<?> clazz, int minWidth, int prefferedWidth, int maxWidth, boolean editable, boolean sortable) {
            super(name, title, clazz, minWidth, prefferedWidth, maxWidth, sortable, editable);
            this.resolver = AbstractBGTableModelXML.this.getResolver(clazz);
        }

        @Override
        public Object getValue(Element e) {
            return this.resolver.getValue(e.getAttribute(this.name));
        }

        @Override
        public Object getValue(StartElement e) {
            Attribute attr = e.getAttributeByName(new QName(this.name));
            return this.resolver.getValue(attr != null ? attr.getValue() : "");
        }

        @Override
        public void setValue(Element e, Object value) {
            e.setAttribute("name", String.valueOf(value));
        }
    }

    abstract class FieldResolver {
        FieldResolver() {
        }

        abstract Object getValue(String var1);
    }
}

