/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.common.dao.AbstractIdDao;

public class MegafonOptionDao
extends AbstractIdDao<MegafonOption> {
    public MegafonOptionDao(Connection con, int moduleId) {
        super(con, moduleId, "megafon_option");
    }

    public List<MegafonOption> list(String filter, String orderBy, Object ... params) throws BGException {
        return super.list(filter, orderBy, params);
    }

    protected MegafonOption getFromRS(ResultSet rs) throws SQLException {
        MegafonOption option = new MegafonOption();
        option.setId(rs.getInt("id"));
        option.setTitle(rs.getString("title"));
        option.setProlongate(rs.getInt("prolongate") == 1);
        option.setUuid(rs.getString("uuid"));
        option.setNpayServiceId(rs.getInt("npay_service_id"));
        option.setPrice(rs.getInt("price"));
        return option;
    }

    protected void updateImpl(MegafonOption option) throws SQLException {
        String query = (option.getId() > 0 ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, uuid=?, prolongate=?, module_service_id=?" + (option.getId() > 0 ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, option.getTitle());
            ps.setString(index++, option.getUuid());
            ps.setInt(index++, option.isProlongate() ? 1 : 0);
            ps.setInt(index++, option.getNpayServiceId());
            if (option.getId() > 0) {
                ps.setInt(index, option.getId());
            }
            ps.executeUpdate();
        }
    }
}

