/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneItemListMode;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneItemListNumber;
import ru.bitel.bgbilling.modules.phone.common.service.BlacklistService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class BlacklistPanel
extends BGUPanel {
    private static final String CLEAR = "left.clear";
    public static final String APPLY = "left.apply";
    private static final Class<BlacklistService> blacklist = BlacklistService.class;
    private boolean newItem = false;
    private int selectedPhoneItemId = -1;
    private BGUTable table;
    private BGTableModel<PhoneItemListNumber> model;
    private BGUComboBox<PhoneItemListMode.Mode> modeComboBox = new BGUComboBox();
    private BGEditor editor;
    private PhoneItemListMode oldMode;

    public void setPhoneItemId(int selectedPhoneItemId) {
        this.selectedPhoneItemId = selectedPhoneItemId;
    }

    protected void jbInit() {
        this.modeComboBox.addItem((Object)PhoneItemListMode.Mode.DISABLED);
        this.modeComboBox.addItem((Object)PhoneItemListMode.Mode.BLACK);
        this.modeComboBox.addItem((Object)PhoneItemListMode.Mode.WHITE);
        this.model = new BGTableModel<PhoneItemListNumber>("numbers"){

            protected void initColumns() {
                this.addColumn("\u041d\u043e\u043c\u0435\u0440 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435", -1, -1, -1, "number");
                this.addColumn("\u041d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d", 100, 100, 100, "newNumber");
            }
        };
        this.table = new BGUTable(this.model);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BlacklistPanel.this.performAction("edit");
                }
            }
        });
        BlacklistApplyPanel applyPanel = new BlacklistApplyPanel();
        BlacklistPanelEditor editNumber = new BlacklistPanelEditor();
        this.editor = new BGEditor(applyPanel.getName());
        this.editor.addForm((JComponent)((Object)applyPanel));
        this.editor.addForm((JComponent)((Object)editNumber));
        JPanel modeSetPanel = new JPanel(new GridBagLayout());
        modeSetPanel.add((Component)this.modeComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        modeSetPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        modeSetPanel.setBorder((Border)new BGTitleBorder("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0436\u0438\u043c"));
        this.setLayout(new GridBagLayout());
        this.add(modeSetPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.oldMode = ((BlacklistService)((ClientContext)this.getContext()).getPort(blacklist)).getMode(this.selectedPhoneItemId);
            this.modeComboBox.setSelectedItem((Object)(this.oldMode == null ? PhoneItemListMode.Mode.DISABLED : this.oldMode.getMode()));
            List numbers = ((BlacklistService)((ClientContext)this.getContext()).getPort(blacklist)).getNumbersForItem(this.selectedPhoneItemId);
            this.model.setData(numbers);
        });
        new AbstractBGUPanel.DefaultAction(APPLY, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                PhoneItemListMode.Mode selectedMode = (PhoneItemListMode.Mode)BlacklistPanel.this.modeComboBox.getSelectedItem();
                if (selectedMode != BlacklistPanel.this.oldMode.getMode()) {
                    BlacklistPanel.this.oldMode.setMode(selectedMode);
                    ((BlacklistService)((ClientContext)BlacklistPanel.this.getContext()).getPort(blacklist)).updateMode(BlacklistPanel.this.oldMode);
                }
                if (selectedMode != PhoneItemListMode.Mode.DISABLED) {
                    List numbers = BlacklistPanel.this.model.getRows();
                    ((BlacklistService)((ClientContext)BlacklistPanel.this.getContext()).getPort(blacklist)).updateNumbers(BlacklistPanel.this.selectedPhoneItemId, numbers);
                }
            }
        };
    }

    private class BlacklistApplyPanel
    extends BGUPanel {
        private BlacklistApplyPanel() {
        }

        protected void jbInit() {
            this.setName("applyPanel");
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction(BlacklistPanel.CLEAR, "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u0440\u0430"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    BlacklistPanel.this.model.setData(new ArrayList());
                }
            };
        }
    }

    private class BlacklistPanelEditor
    extends BGUPanel {
        private PhoneItemListNumber current;
        private BGTextField phoneField = new BGTextField();

        private BlacklistPanelEditor() {
        }

        protected void jbInit() {
            this.setBorder((Border)new BGTitleBorder("\u041d\u043e\u043c\u0435\u0440:"));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.phoneField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                BlacklistPanel.this.newItem = true;
                if (BlacklistPanel.this.modeComboBox.getSelectedItem() == PhoneItemListMode.Mode.DISABLED) {
                    throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u043e\u043c\u0435\u0440\u0430, \u0441\u043f\u0438\u0441\u043a\u0438 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0438\u043d\u0442\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u044b.");
                }
                this.current = new PhoneItemListNumber();
                this.current.setPhoneItemId(BlacklistPanel.this.selectedPhoneItemId);
                this.phoneField.setText("");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                BlacklistPanel.this.newItem = false;
                this.current = (PhoneItemListNumber)BlacklistPanel.this.model.getSelectedRow();
                this.checkCurrent();
                this.phoneField.setText(this.current.getNumber());
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                this.current = (PhoneItemListNumber)BlacklistPanel.this.model.getSelectedRow();
                this.checkCurrent();
                BlacklistPanel.this.model.deleteRow((Object)this.current);
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u041e\u043a"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    BlacklistPanelEditor.this.checkCurrent();
                    if (Utils.isBlankString((String)BlacklistPanelEditor.this.phoneField.getText())) {
                        throw new BGMessageException("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440!");
                    }
                    BlacklistPanelEditor.this.current.setNumber(BlacklistPanelEditor.this.phoneField.getText());
                    if (BlacklistPanel.this.newItem) {
                        BlacklistPanel.this.model.addRow((Object)BlacklistPanelEditor.this.current);
                    }
                    BlacklistPanelEditor.this.performActionClose();
                }
            };
        }

        private void checkCurrent() throws BGMessageException {
            if (this.current == null) {
                throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            }
        }
    }
}

