/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffAdditionalItem;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffIncludeItem;
import ru.bitel.bgbilling.modules.runtel.common.service.RunTelService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class ServiceConfigTariff
extends BGUPanel {
    private BGUTable table = null;
    private List<Service> services = null;
    private EditorPanel editorPanel = null;
    private RunTelService runTelService = null;
    private ModuleService moduleService = null;
    private TariffTableModel tariffTableModel = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getTariffTablePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getTariffEditorPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTariffTablePanel() {
        this.tariffTableModel = new TariffTableModel(TariffTableModel.class.getName());
        this.table = new BGUTable((TableModel)((Object)this.tariffTableModel));
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                RunTelTariff runTelTariff = (RunTelTariff)ServiceConfigTariff.this.tariffTableModel.getSelectedRow();
                if (mouseEvent.getClickCount() == 2 && runTelTariff != null) {
                    ServiceConfigTariff.this.showEditor(runTelTariff);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTariffEditorPanel() {
        if (this.editorPanel == null) {
            this.editorPanel = new EditorPanel();
            this.editorPanel.setMinimumSize(new Dimension(100, 300));
            this.editorPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    ServiceConfigTariff.this.performAction("refresh");
                    ServiceConfigTariff.this.table.setEnabled(true);
                }
            });
        }
        return this.editorPanel;
    }

    private RunTelService getRunTelService() {
        if (this.runTelService == null) {
            this.runTelService = (RunTelService)((ClientContext)this.getContext()).getPort(RunTelService.class);
        }
        return this.runTelService;
    }

    private ModuleService getModuleService() {
        if (this.moduleService == null) {
            this.moduleService = (ModuleService)new ClientContext("kernel", 0, 0, "").getWebService(ModuleService.class);
        }
        return this.moduleService;
    }

    private void showEditor(RunTelTariff runTelTariff) {
        this.editorPanel.init(runTelTariff);
        this.editorPanel.setVisible(true);
        this.table.setEnabled(false);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.services = this.getModuleService().serviceList(((ClientContext)this.getContext()).getModuleId());
            SearchResult searchResult = this.getRunTelService().searchRunTelTariff();
            this.tariffTableModel.setData(searchResult.getList());
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (!this.editorPanel.isVisible()) {
                this.showEditor(new RunTelTariff());
            }
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            RunTelTariff runTelTariff = (RunTelTariff)this.tariffTableModel.getSelectedRow();
            if (!this.editorPanel.isVisible() && runTelTariff != null) {
                this.showEditor(runTelTariff);
            }
        });
    }

    class EditorPanel
    extends JPanel {
        private BGTextField costField;
        private BGTextField tariffTitle;
        private JTabbedPane tabbedPane;
        private RunTelTariff runTelTariff;
        private BGUComboBox<IdTitle> serviceComboBox;
        private TariffIncludeTableModel includeTableModel;
        private TariffAdditionalServiceTableModel additionalTableModel;

        public EditorPanel() {
            super(new GridBagLayout());
            this.costField = new BGTextField(10);
            this.tariffTitle = new BGTextField(50);
            this.tabbedPane = null;
            this.runTelTariff = null;
            this.serviceComboBox = null;
            this.includeTableModel = null;
            this.additionalTableModel = null;
            BGButtonPanelOkCancel bgButtonPanelOkCancel = new BGButtonPanelOkCancel();
            bgButtonPanelOkCancel.addActionListener(e -> {
                if ("cancel".equals(e.getActionCommand())) {
                    ServiceConfigTariff.this.editorPanel.setVisible(false);
                } else if ("ok".equals(e.getActionCommand())) {
                    ServiceConfigTariff.this.editorPanel.save();
                }
            });
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add("\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u0442\u0430\u0440\u0438\u0444", this.getTariffIncludePanel());
            this.tabbedPane.add("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", this.getAdditionalServicePanel());
            this.setVisible(false);
            this.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
            this.add((Component)this.getDataPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.tabbedPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)bgButtonPanelOkCancel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        public void init(RunTelTariff runTelTariff) {
            JSONObject additionalJsonObject;
            String config;
            JSONObject jsonObject;
            JSONObject includeJsonObject;
            try {
                if (runTelTariff.getId() > 0) {
                    runTelTariff = ServiceConfigTariff.this.getRunTelService().getRunTelTariff(runTelTariff.getId());
                }
                this.includeTableModel.setData(ServiceConfigTariff.this.getRunTelService().getTariffIncludeItems());
                this.additionalTableModel.setData(ServiceConfigTariff.this.getRunTelService().getTariffAdditionalServiceItems());
                this.serviceComboBox.setData(ServiceConfigTariff.this.services.stream().map(a -> a.toIdTitle()).toList());
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            this.runTelTariff = runTelTariff;
            this.tariffTitle.setText(runTelTariff.getTitle());
            this.costField.setText(runTelTariff.getCost().toPlainString());
            for (int index = 0; index < this.serviceComboBox.getItemCount(); ++index) {
                if (((IdTitle)this.serviceComboBox.getItemAt(index)).getId() != runTelTariff.getServiceId()) continue;
                this.serviceComboBox.setSelectedIndex(index);
                break;
            }
            if ((includeJsonObject = (jsonObject = new JSONObject(Utils.isEmptyString((String)(config = runTelTariff.getConfig())) ? "{}" : config)).optJSONObject("include")) != null) {
                this.includeTableModel.getRows().forEach(r -> r.setValue(includeJsonObject.optInt(r.getName(), 0)));
            }
            if ((additionalJsonObject = jsonObject.optJSONObject("additional")) != null) {
                this.additionalTableModel.getRows().forEach(r -> {
                    JSONObject itemJsonObject = additionalJsonObject.optJSONObject(r.getName());
                    if (itemJsonObject != null) {
                        r.setSelected(itemJsonObject.optBoolean("enable", false));
                        r.setServiceId(itemJsonObject.optInt("serviceId", 0));
                        r.setCost(itemJsonObject.optBigDecimal("cost", BigDecimal.ZERO));
                    }
                });
            }
            this.tabbedPane.setSelectedIndex(0);
        }

        public void save() {
            this.runTelTariff.setTitle(this.tariffTitle.getText());
            this.runTelTariff.setServiceId(((IdTitle)this.serviceComboBox.getSelectedItem()).getId());
            this.runTelTariff.setCost(this.getCost(this.costField.getText()));
            JSONObject jsonObject = new JSONObject();
            JSONObject includeJsonObject = new JSONObject();
            this.includeTableModel.getRows().forEach(r -> includeJsonObject.put(r.getName(), r.getValue()));
            jsonObject.put("include", (Object)includeJsonObject);
            JSONObject additionalJsonObject = new JSONObject();
            this.additionalTableModel.getRows().forEach(r -> {
                JSONObject itemJsonObject = new JSONObject();
                itemJsonObject.put("enable", r.isSelected());
                itemJsonObject.put("serviceId", r.getServiceId());
                itemJsonObject.put("cost", (Object)r.getCost());
                additionalJsonObject.put(r.getName(), (Object)itemJsonObject);
            });
            jsonObject.put("additional", (Object)additionalJsonObject);
            this.runTelTariff.setConfig(jsonObject.toString());
            if (this.runTelTariff.getCost().compareTo(BigDecimal.ZERO) == -1) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0438!!!");
                return;
            }
            try {
                ServiceConfigTariff.this.getRunTelService().updateTariff(this.runTelTariff);
                this.setVisible(false);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        private JPanel getDataPanel() {
            this.serviceComboBox = new BGUComboBox();
            this.costField.setHorizontalAlignment(4);
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.tariffTitle, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.serviceComboBox, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.costField, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getTariffIncludePanel() {
            this.includeTableModel = new TariffIncludeTableModel(TariffIncludeTableModel.class.getName());
            final BGUTable table = new BGUTable((TableModel)((Object)this.includeTableModel));
            table.setSelectionMode(0);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    TariffIncludeItem includeItem = (TariffIncludeItem)EditorPanel.this.includeTableModel.getSelectedRow();
                    if (mouseEvent.getClickCount() == 2 && includeItem != null) {
                        EditorPanel.this.setIncludeValue(includeItem);
                        table.repaint();
                    }
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        private void setIncludeValue(TariffIncludeItem includeItem) {
            int value;
            BGTextField valueField = new BGTextField(20);
            valueField.setHorizontalAlignment(0);
            valueField.setText(String.valueOf(includeItem.getValue()));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(includeItem.getTitle()), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)valueField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 5, 5, 5), 0, 0));
            int optionId = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), panel, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 2);
            if (optionId == 0 && (value = Utils.parseInt((String)valueField.getText(), (int)0)) > -1) {
                includeItem.setValue(value);
            }
        }

        private JPanel getAdditionalServicePanel() {
            this.additionalTableModel = new TariffAdditionalServiceTableModel(TariffAdditionalServiceTableModel.class.getName());
            final BGUTable table = new BGUTable((TableModel)((Object)this.additionalTableModel));
            table.setSelectionMode(0);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    TariffAdditionalItem additionalServiceItem = (TariffAdditionalItem)EditorPanel.this.additionalTableModel.getSelectedRow();
                    if (mouseEvent.getClickCount() == 2 && additionalServiceItem != null) {
                        EditorPanel.this.setAdditionalService(additionalServiceItem);
                        table.repaint();
                    }
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        private void setAdditionalService(TariffAdditionalItem additionalServiceItem) {
            BGUComboBox servicesComboBox = new BGUComboBox();
            servicesComboBox.setData(ServiceConfigTariff.this.services.stream().map(a -> a.toIdTitle()).toList());
            servicesComboBox.insertItemAt((Object)new IdTitle(0, "\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430"), 0);
            for (int index = 0; index < servicesComboBox.getItemCount(); ++index) {
                IdTitle idTitle = (IdTitle)servicesComboBox.getItemAt(index);
                if (idTitle.getId() != additionalServiceItem.getServiceId()) continue;
                servicesComboBox.setSelectedIndex(index);
                break;
            }
            JCheckBox onCheckBox = new JCheckBox("\u0443\u0441\u043b\u0443\u0433\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u0435");
            onCheckBox.setSelected(additionalServiceItem.isSelected());
            BGTextField costField = new BGTextField(15);
            costField.setHorizontalAlignment(2);
            costField.setText(additionalServiceItem.getCost().toPlainString());
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(additionalServiceItem.getTitle()), new GridBagConstraints(0, gridy++, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
            panel.add((Component)servicesComboBox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
            panel.add((Component)costField, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)onCheckBox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
            int optionId = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), panel, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 2);
            if (optionId == 0) {
                additionalServiceItem.setSelected(onCheckBox.isSelected());
                additionalServiceItem.setServiceId(((IdTitle)servicesComboBox.getSelectedItem()).getId());
                BigDecimal value = this.getCost(costField.getText());
                if (value.compareTo(BigDecimal.ZERO) > -1) {
                    additionalServiceItem.setCost(value);
                }
            }
        }

        private BigDecimal getCost(String cost) {
            BigDecimal value = Utils.parseBigDecimal((String)cost.replace(',', '.'), (BigDecimal)BigDecimal.ZERO);
            value = value.setScale(2, RoundingMode.HALF_UP);
            return value;
        }
    }

    class TariffTableModel
    extends BGTableModel<RunTelTariff> {
        public TariffTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", 100, 200, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class TariffAdditionalServiceTableModel
    extends BGTableModel<TariffAdditionalItem> {
        public TariffAdditionalServiceTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("X", 30, 30, 30, "selected", true);
            this.addColumn("\u041a\u043b\u044e\u0447", 150, 180, 200, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 100, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 100, 100, -1, "serviceId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, 100, 100, "cost", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValue(TariffAdditionalItem value, int columnIndex) throws BGException {
            String identifier = this.getIdentifier(columnIndex);
            if ("serviceId".equals(identifier)) {
                int serviceId = value.getServiceId();
                if (serviceId == 0) {
                    return "\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430";
                }
                Service service = ServiceConfigTariff.this.services.stream().filter(a -> a.getId() == serviceId).findFirst().orElse(null);
                return service == null ? "???" : service.getTitle();
            }
            return super.getValue((Object)value, columnIndex);
        }
    }

    class TariffIncludeTableModel
    extends BGTableModel<TariffIncludeItem> {
        public TariffIncludeTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043b\u044e\u0447", 180, 180, 180, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 180, 180, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 100, 100, "value", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
        }
    }
}

