/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostProtocol;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostProtocolDao
extends AbstractDao<ForpostProtocol> {
    public ForpostProtocolDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_protocol");
    }

    public List<ForpostProtocol> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    protected ForpostProtocol getFromRS(ResultSet rs) throws SQLException, BGException {
        return new ForpostProtocol(rs.getString("id"), rs.getString("name"));
    }

    protected void updateImpl(ForpostProtocol forpostProtocol) throws BGException {
        if (forpostProtocol != null) {
            try {
                int parameterIndex = 1;
                boolean insert = forpostProtocol.getId() != null;
                String sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET id=?, name=?" + (insert ? "" : " WHERE id=?");
                PreparedStatement ps = this.con.prepareStatement(sql);
                ps.setString(parameterIndex++, forpostProtocol.getId());
                ps.setString(parameterIndex++, forpostProtocol.getName());
                if (!insert) {
                    ps.setString(parameterIndex++, forpostProtocol.getId());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(ps.toString());
                }
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void searchForpostProtocols(SearchResult<ForpostProtocol> searchResult) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + (page != null ? page.sqlLimit() : ""), 1);){
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void doSync(ForpostProtocol[] protocols) throws BGException {
        if (protocols == null) {
            return;
        }
        long now = System.currentTimeMillis();
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, name=?, sync_datetime=? ON DUPLICATE KEY UPDATE name=?, sync_datetime=?");
             PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>?");){
            for (ForpostProtocol forpostProtocol : protocols) {
                int parameterIndex = 1;
                psInsert.setString(parameterIndex++, forpostProtocol.getId());
                psInsert.setString(parameterIndex++, forpostProtocol.getName());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setString(parameterIndex++, forpostProtocol.getName());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
            }
            psDelete.setLong(1, now);
            psDelete.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

