/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.searchimpl;

import jakarta.xml.ws.Holder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractSearchableFilters;
import ru.bitel.bgbilling.kernel.contract.search.server.AbstractContractSearchable;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountStatus;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class SearchByNumber
extends AbstractContractSearchable {
    private final String ACCOUNT_STATE = "acctount_state";
    private final String DEVICE_ID = "account_id";
    private final String NUMBER = "number";

    public boolean check(String searchData) {
        return !searchData.contains("+\\D");
    }

    public List<JSONObject> search(String searchData, int moduleId, ContractSearchableFilters filters, Holder<Page> pageHolder) throws BGException {
        System.out.println("ID \u043c\u043e\u0434\u0443\u043b\u044f Voice=" + moduleId + " \u041d\u0430 \u0441\u0430\u043c\u043e\u043c \u0434\u0435\u043b\u0435=217");
        ServerContext serverContext = (ServerContext)ServerContext.get();
        VoiceAccountService voiceAccountService = (VoiceAccountService)serverContext.getService(VoiceAccountService.class, 217);
        long number = Utils.parseLong((String)searchData, (long)-1L);
        if (number < 0L) {
            return Collections.emptyList();
        }
        Calendar date = Calendar.getInstance();
        Period period = new Period();
        date.add(1, -5);
        period.setDateFrom(date.getTime());
        List accounts = voiceAccountService.voiceSearchAccount(-1L, null, number, -1, null, period, (Page)pageHolder.value).getList();
        if (Utils.isEmptyCollection((Collection)accounts)) {
            return Collections.emptyList();
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (VoiceAccount voiceAccount : accounts) {
            JSONObject object = new JSONObject();
            object.put("cid", voiceAccount.getContractId());
            object.put("contractTitle", (Object)voiceAccount.getContractTitle());
            object.put("number", (Object)String.valueOf(voiceAccount.getNumber()));
            object.put("account_id", voiceAccount.getDeviceId());
            object.put("acctount_state", (Object)this.getAccountState(voiceAccount.getDeviceState()));
            object.put("color", (Object)(voiceAccount.getDeviceState() == 1 ? "green" : ""));
            result.add(object);
        }
        return result;
    }

    private String getAccountState(int state) {
        return Optional.ofNullable(VoiceAccountStatus.getVoiceAccountStatus((int)state)).map(a -> a.getTitle()).orElse("");
    }

    public JSONObject metadata() {
        JSONObject metadata = new JSONObject();
        JSONArray titles = new JSONArray();
        titles.put((Object)this.getTitleContractId("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        titles.put((Object)this.getTitleContractTitle("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        titles.put((Object)this.getTitle("number", "\u041d\u043e\u043c\u0435\u0440", 100));
        titles.put((Object)this.getTitle("account_id", "ID \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430"));
        titles.put((Object)this.getTitle("acctount_state", "\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430", 50));
        metadata.put("titles", (Object)titles);
        return metadata;
    }

    public String getTitle() {
        return "\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430";
    }
}

