/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.task;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceLogManagementService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class VoiceTaskGenerator
extends TaskBase {
    private Logger logger = LogManager.getLogger();
    private Set<Integer> devices = new HashSet<Integer>();
    private int dayMinus = -1;

    protected boolean initTask() {
        this.devices = Utils.toIntegerSet((String)this.taskSetup.get("devices"));
        this.dayMinus = this.taskSetup.getInt("day.minus", -1);
        return true;
    }

    protected void executeTask() {
        try {
            ServerContext context = (ServerContext)ServerContext.get();
            VoiceLogManagementService logService = (VoiceLogManagementService)context.getService(VoiceLogManagementService.class, Integer.valueOf(this.moduleId).intValue());
            VoiceDeviceService deviceService = (VoiceDeviceService)context.getService(VoiceDeviceService.class, Integer.valueOf(this.moduleId).intValue());
            Calendar time = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)TimeUtils.plusPeriod((Calendar)this.getOperatingTime(), (int)5, (int)this.dayMinus));
            Date day = TimeUtils.convertCalendarToDate((Calendar)time);
            for (Integer deviceId : this.devices) {
                VoiceDevice device = (VoiceDevice)deviceService.deviceGet(deviceId.intValue());
                if (!TimeUtils.dateInRange((Date)day, (Date)device.getDateFrom(), (Date)device.getDateTo())) {
                    this.logger.warn("Skip device: " + deviceId + " [" + TimeUtils.formatDate((Date)device.getDateFrom()) + "-" + TimeUtils.formatDate((Date)device.getDateTo()) + "]");
                    continue;
                }
                this.logger.info("adding new day " + day + " for device " + deviceId);
                logService.voiceAddProcessLogs(deviceId, Collections.singletonList(day));
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Voice: \u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0434\u0430\u043d\u0438\u0439 \u043d\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 \u043b\u043e\u0433\u043e\u0432";
    }
}

