/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.event.worker;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.alfabank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.Utils;

public class AlfabankAutopaymentEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private ContractDao contractDao;

    public AlfabankAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), AlfabankAutopaymentEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.getLogger().info("Starting AlfabankAutopaymentEventWorker for moduleId: {}", (Object)moduleId);
        new Thread((Runnable)((Object)this), "alfabank-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.contractDao = new ContractDao(((EventListenerContext)this.context).getConnection(), 0);
        try {
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.contractDao.close();
            this.autopaymentManager.close();
            this.transactionManager.close();
            this.contractDao = null;
            this.transactionManager = null;
            this.autopaymentManager = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        Contract contract;
        AlfabankAutopaymentEvent event = (AlfabankAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
        BigDecimal sum = event.getSum();
        if (sum == null) {
            sum = autopayment.getSum();
        }
        if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = (Contract)this.contractDao.get(contractId)) != null) {
            String customerAddress = ContractUtils.getCustomerAddress((Connection)((EventListenerContext)this.context).getConnection(), (int)this.moduleId, (int)contractId);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            Transaction transaction = this.transactionManager.registerOrder(contractId, contract.getTitle(), customerAddress, sum, dataMap, true, true, null);
            String result = this.transactionManager.paymentOrderBinding(transaction, autopayment);
            if (result != null) {
                Map parameterMap = Utils.stringToPairsHash((String)result.replace("\n", ";"));
                if ("0".equals(parameterMap.get("errorCode"))) {
                    this.transactionManager.doCheckRequest(contractId, true);
                } else {
                    transaction.setStatus(TransactionStatus.ERROR.getCode());
                    transaction.setParameters((transaction.getParameters() == null ? "" : transaction.getParameters()) + result);
                    this.transactionManager.update(transaction);
                }
            }
        }
        return null;
    }
}

