/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.viewer;

import bitel.billing.module.common.JRViewer;
import jakarta.activation.DataSource;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.client.viewer.Stylesheet;
import ru.bitel.bgbilling.modules.bill.client.viewer.StylesheetType;

public class JRStylesheet
extends Stylesheet {
    private JRView viewer;
    private JasperPrint jp = null;

    public JRStylesheet() {
        this.type = StylesheetType.JR;
        try {
            this.viewer = new JRView(null);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @Override
    public PageFormat getPageFormat(DataSource ds, PrinterJob printJob, int pageIndex) throws IndexOutOfBoundsException {
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        this.jp = null;
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = (JasperPrint)JRLoader.loadObject((InputStream)ds.getInputStream());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.jp = jasperPrint;
        switch (jasperPrint.getOrientationValue()) {
            case LANDSCAPE: {
                pageFormat.setOrientation(0);
                paper.setSize(jasperPrint.getPageHeight(), jasperPrint.getPageWidth());
                paper.setImageableArea(0.0, 0.0, jasperPrint.getPageHeight(), jasperPrint.getPageWidth());
                break;
            }
            default: {
                pageFormat.setOrientation(1);
                paper.setSize(jasperPrint.getPageWidth(), jasperPrint.getPageHeight());
                paper.setImageableArea(0.0, 0.0, jasperPrint.getPageWidth(), jasperPrint.getPageHeight());
            }
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (Thread.currentThread().isInterrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if (pageIndex < 0 || pageIndex >= this.jp.getPages().size()) {
            return 1;
        }
        try {
            JRGraphics2DExporter exporter = new JRGraphics2DExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.jp);
            exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)graphics);
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pageIndex);
            exporter.exportReport();
        }
        catch (JRException e) {
            e.printStackTrace();
            throw new PrinterException(e.getMessage());
        }
        return 0;
    }

    @Override
    public JComponent getComponent() {
        return this.viewer;
    }

    @Override
    public void showDocument(DataSource ds) {
        try {
            JasperPrint jp = (JasperPrint)JRLoader.loadObject((InputStream)ds.getInputStream());
            this.viewer.setReport(jp);
            this.pageCount = jp.getPages().size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.jp.getPages().size();
    }

    @Override
    public void scale(double scale) {
        this.viewer.scale((float)scale);
    }

    @Override
    public void save(File file, InputStream inputStream) {
        try {
            if (this.viewer.getReport() != null) {
                FileOutputStream fos = new FileOutputStream(file);
                JasperExportManager.exportReportToPdfStream((JasperPrint)this.viewer.getReport(), (OutputStream)fos);
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e1) {
            ClientUtils.showErrorMessageDialog((Throwable)e1);
        }
    }

    @Override
    public void showPage(int pageNum) {
        JRBasePrintHyperlink h = new JRBasePrintHyperlink();
        h.setHyperlinkType(HyperlinkTypeEnum.LOCAL_PAGE);
        h.setHyperlinkPage(Integer.valueOf(pageNum));
        this.viewer.gotoHyperlink(h);
    }

    @Override
    public void clear() {
    }

    private class JRView
    extends JRViewer {
        public JRView(JasperPrint jasperPrint) throws JRException {
            super(jasperPrint);
            this.tlbToolBar.setVisible(false);
            this.lblStatus.setVisible(false);
        }

        public void scale(float zoom) {
            super.refreshPage();
        }

        public JasperPrint getReport() {
            return this.jasperPrint;
        }
    }
}

