/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.task;

import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.AutoprintProcessor;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class AutoprintAutoBatch
extends RunTask {
    private List<Payment> autoPaymentIds;

    public AutoprintAutoBatch(List<Payment> autoPaymentIds) {
        this.autoPaymentIds = autoPaymentIds;
    }

    public String getDescription() {
        return "\u041f\u043b\u0430\u0433\u0438\u043d CashCheck. \u0417\u0430\u0434\u0430\u0447\u0430 \u0434\u043e\u043f\u0435\u0447\u0430\u0442\u0438 auto-\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 (" + this.autoPaymentIds.size() + "\u0448\u0442)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.processQueue(con, conSlave);
        }
        catch (Exception e) {
            this.getLogger().error("error AutoprintAutoBatch task", (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
    }

    private void processQueue(Connection con, Connection conSlave) throws BGException {
        try (PaymentDao pm = new PaymentDao(con);){
            this.getLogger().info("cashcheck autoprint: print batch auto: queue size: " + this.autoPaymentIds.size() + "...");
            for (Payment p : this.autoPaymentIds) {
                ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment bgpayment = (ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment)pm.get(p.getPaymentId());
                AutoprintProcessor.processNewPayment(PrinterManager.PaymentPrintMode.auto, bgpayment, this.setup, con, conSlave);
                try {
                    CashCheckUtils.sleepBatch();
                }
                catch (InterruptedException e) {
                    pm.close();
                    return;
                }
            }
        }
    }

    public String getUniqueKeyQueue() {
        List paymentids = this.autoPaymentIds.stream().map(p -> p.getPaymentId()).collect(Collectors.toList());
        return "cashcheck-autobatch-" + Utils.toString(paymentids);
    }

    public String getUniqueKeyParallel() {
        return "cashcheck-autobatch";
    }
}

