/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.client;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class LoginPanel
extends ServicePanel {
    private BGButtonPanelRestoreOkCancelHelp controlPanel = new BGButtonPanelRestoreOkCancelHelp();
    private BGTable loginTable = new BGTable();
    private JPanel editor = new JPanel(new GridBagLayout());

    public LoginPanel() {
        this.setTabbedPanel();
        this.jbInit();
        this.loginTable.setHeader(this.rb_name, "login");
        JPopupMenu popupMenu = this.createPopupMenu(this.loginTable);
        this.initTransferContractPopup(popupMenu, this.loginTable, "MoveLogin", "id", "lid");
        this.initWrapContractPopup(popupMenu, this.loginTable, "WrapLogin", "id", "lid");
    }

    private void jbInit() {
        this.setLayout(this.cardLayout1);
        this.loginTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    LoginPanel.this.editItem();
                }
            }
        });
        this.controlPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.actionPerformed(e);
            }
        });
        this.add(new JScrollPane((Component)this.loginTable), "table");
        this.add(this.editor, "editor");
        this.editor.add((Component)this.editorsTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editor.add((Component)this.controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
    }

    public void setData() {
        if (this.getContractId() > -1 && this.getModuleId() > -1) {
            this.cardLayout1.show((Container)((Object)this), "table");
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ContractInfo");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAttribute("object_id", this.objectId);
            this.setDocument(this.getDocument(request));
        }
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            this.loginTable.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }

    public void newItem() {
        if (this.editor.isVisible()) {
            this.showMessageDialog();
            return;
        }
        this.initServiceSubPanel(this.editorsTabbedPane, 0);
        this.cardLayout1.show((Container)((Object)this), "editor");
    }

    public void editItem() {
        if (!this.editor.isVisible()) {
            String id = ClientUtils.getRowId((BGTable)this.loginTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u043e\u0433\u0438\u043d", null);
            if (id != null) {
                this.initServiceSubPanel(this.editorsTabbedPane, Utils.parseInt((String)id, (int)-1));
                this.cardLayout1.show((Container)((Object)this), "editor");
            }
        } else {
            this.showMessageDialog();
            return;
        }
    }

    public void deleteItem() {
        if (!this.editor.isVisible()) {
            String id = ClientUtils.getRowId((BGTable)this.loginTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u043e\u0433\u0438\u043d", null);
            if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043b\u043e\u0433\u0438\u043d?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043b\u043e\u0433\u0438\u043d\u0430", 0) == 0) {
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("DeleteLogin");
                request.setModuleId(this.getModuleId());
                request.setContractId(this.getContractId());
                request.setAttribute("id", id);
                Document doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    this.cardLayout1.show((Container)((Object)this), "table");
                    this.setData();
                }
            } else {
                return;
            }
        }
    }
}

