/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean.pattern;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariableType;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.BarcodeItem;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentPatternUtils;
import ru.bitel.common.Utils;

public abstract class AbstractDocumentProcessor {
    Map<String, Object> variableData;
    protected Map<String, List<Map<String, String>>> tableData;
    protected Document document;
    protected DocumentPattern pattern;
    protected Connection con;

    void iterateOverParagraphList(List<XWPFParagraph> paragraphList) throws IOException, InvalidFormatException {
        for (XWPFParagraph xwpfParagraph : paragraphList) {
            XWPFParagraph paragraph = AbstractDocumentProcessor.joinSomeRun(xwpfParagraph);
            String paragraphText = paragraph.getText();
            if (Utils.isBlankString((String)paragraphText)) continue;
            List<String> varList = DocumentPatternUtils.getKeysFromString(paragraphText);
            for (String varName : varList) {
                DocumentVariable documentVariable = this.getDocumentVariable(varName);
                if (documentVariable != null && documentVariable.getType() == DocumentVariableType.BARCODE) {
                    BarcodeItem item = (BarcodeItem)this.variableData.get(varName);
                    Path barcodePath = item.getBarcodePath();
                    XWPFRun run = paragraph.createRun();
                    run.addPicture(Files.newInputStream(barcodePath, new OpenOption[0]), XWPFDocument.PICTURE_TYPE_PNG, barcodePath.getFileName().toString(), Units.toEMU((double)item.getHeight()), Units.toEMU((double)item.getWidth()));
                    this.replaceTextInParagraph(paragraph, varName, "");
                    Files.delete(barcodePath);
                    continue;
                }
                this.replaceTextInParagraph(paragraph, varName, (String)this.variableData.get(varName));
            }
        }
    }

    private void replaceTextInParagraph(XWPFParagraph paragraph, String varName, String value) {
        List runList = paragraph.getRuns();
        for (int i = runList.size() - 1; i >= 0; --i) {
            XWPFRun run = (XWPFRun)runList.get(i);
            List tElems = run.getCTR().getTList();
            for (CTText ctText : tElems) {
                String tText = ctText.getStringValue();
                ctText.setStringValue(DocumentPatternUtils.replaceText(tText, varName, value));
            }
        }
    }

    private DocumentVariable getDocumentVariable(String varName) {
        return this.pattern.getVariableList().stream().filter(n -> n.getTitle().equals(varName)).findFirst().orElse(null);
    }

    static XWPFParagraph joinSomeRun(XWPFParagraph paragraph) {
        if (Utils.isBlankString((String)paragraph.getText())) {
            return paragraph;
        }
        paragraph = AbstractDocumentProcessor.preJoinSomeRunBraces(paragraph);
        List runList = paragraph.getRuns();
        String textNextRun = "";
        for (int i = runList.size() - 1; i >= 0; --i) {
            XWPFRun run = (XWPFRun)runList.get(i);
            if (run.getCTR().getTList().isEmpty()) continue;
            CTText ctText = (CTText)run.getCTR().getTList().get(0);
            ctText.setStringValue(ctText.getStringValue() + textNextRun);
            String textRun = run.getText(0);
            int firstCloseBkt = textRun.indexOf("}");
            if (firstCloseBkt == -1) continue;
            String beginString = textRun.substring(0, firstCloseBkt + 1);
            int firstOpenBkt = beginString.indexOf("{");
            if (firstOpenBkt == -1) {
                textNextRun = beginString;
                String NewText = ctText.getStringValue().substring(firstCloseBkt + 1);
                ctText.setStringValue(NewText);
                continue;
            }
            if (!Utils.isEmptyString((String)textNextRun)) {
                run.setText(textRun);
                int lastOpenBkt = textRun.indexOf("{");
                if (lastOpenBkt != -1) {
                    ctText.setStringValue(textRun.substring(0, lastOpenBkt));
                } else {
                    ctText.setStringValue("");
                }
            }
            textNextRun = "";
        }
        return paragraph;
    }

    static XWPFParagraph preJoinSomeRunBraces(XWPFParagraph paragraph) {
        List runList = paragraph.getRuns();
        if (runList.size() < 3) {
            return paragraph;
        }
        for (int i = 0; i < runList.size() - 2; ++i) {
            XWPFRun run1 = (XWPFRun)runList.get(i);
            if (run1.getCTR().getTList().isEmpty() || !run1.getText(0).endsWith("{")) continue;
            XWPFRun run2 = (XWPFRun)runList.get(i + 1);
            XWPFRun run3 = (XWPFRun)runList.get(i + 2);
            if (!run3.getText(0).startsWith("}") || run2.getText(0).contains("{") || run2.getText(0).contains("}") || run1.getCTR().getTList().isEmpty() || run2.getCTR().getTList().isEmpty() || run3.getCTR().getTList().isEmpty()) continue;
            CTText ctt1 = (CTText)run1.getCTR().getTList().get(0);
            CTText ctt2 = (CTText)run2.getCTR().getTList().get(0);
            CTText ctt3 = (CTText)run3.getCTR().getTList().get(0);
            ctt1.setStringValue(ctt1.getStringValue().substring(0, ctt1.getStringValue().length() - 1));
            ctt2.setStringValue("{" + ctt2.getStringValue() + "}");
            ctt3.setStringValue(ctt3.getStringValue().substring(1));
        }
        return paragraph;
    }
}

