/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.action.web;

import jakarta.activation.DataHandler;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.ws.Holder;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.io.IOUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionSessionReport
extends AbstractAction {
    @Resource
    ModuleService moduleService;
    @Resource
    InetSessionService sessionService;
    @Resource
    InetServService servService;

    public ActionSessionReport() {
        super("inet");
    }

    public void execute() throws BGException {
        int serviceId = this.req.getInt("inetServId", -1);
        int unit = this.req.getInt("unit", 0x100000);
        Page page = this.getPage();
        HashSet<Integer> trafficTypeIds = new HashSet<Integer>();
        List services = this.moduleService.serviceList(this.moduleId);
        List trafficTypes = this.servService.trafficTypeList();
        for (TrafficType type : trafficTypes) {
            trafficTypeIds.add(type.getId());
        }
        List servList = this.servService.inetServList(this.contractId, "dateTo, dateFrom");
        servList.stream().forEach(serv -> serv.setTitle(serv.getTitle() + " (" + TimeUtils.formatPeriod((Date)serv.getDateFrom(), (Date)serv.getDateTo()) + ")"));
        this.setResultParam("servs", servList);
        this.setResultParam("trafficTypes", trafficTypes);
        this.setResultParam("services", services);
        this.setResultParam("inetServId", serviceId);
        this.setResultParam("unit", unit);
        if (serviceId > 0) {
            this.setResult(this.sessionService.inetSessionAliveContractList(this.contractId, Collections.singleton(serviceId), null, null, trafficTypeIds, null, page));
        }
        super.execute();
    }

    public void history() throws BGException {
        int unit = this.req.getInt("unit", 0x100000);
        int inetServId = this.req.getInt("inetServId", -1);
        Period period = this.getPeriodByYearMonthDays();
        List trafficTypes = this.servService.trafficTypeList();
        List services = this.moduleService.serviceList(this.moduleId);
        List inetServList = this.servService.inetServList(this.contractId, "dateTo, dateFrom");
        inetServList.stream().forEach(serv -> serv.setTitle(serv.getTitle() + " (" + TimeUtils.formatPeriod((Date)serv.getDateFrom(), (Date)serv.getDateTo()) + ")"));
        this.setResultParam("servs", inetServList);
        this.setResultParam("trafficTypes", trafficTypes);
        this.setResultParam("services", services);
        this.setResultParam("inetServId", inetServId);
        this.setResultParam("unit", unit);
        if (inetServId > 0) {
            this.setResult(this.sessionService.inetSessionLogContractList(this.contractId, Collections.singleton(inetServId), period.getDateFrom(), period.getDateTo(), null, null, this.getPage()));
        }
    }

    public void historyExport() throws BGException {
        int inetServId = this.req.getInt("inetServId", -1);
        String format = this.req.get("exportFormat", "html");
        boolean zipped = this.req.getInt("zip", 0) > 0;
        String fileName = "session_report";
        String fileNameWithExt = fileName + "." + format;
        Period period = this.getPeriodByYearMonthDays();
        Holder data = new Holder();
        this.sessionService.inetSessionExport(this.contractId, Collections.singleton(inetServId), period.getDateFrom(), period.getDateTo(), null, null, null, data, false, format, null, 1L);
        HttpServletResponse resp = this.context.getResponse();
        if (zipped) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".zip;");
        } else if (format.equals("html")) {
            resp.setContentType("text/html");
            this.setResultParam("contentType", "binary");
        } else if (format.equals("csv")) {
            resp.setContentType("text/csv");
            this.setResultParam("contentType", "binary");
            resp.addHeader("Content-Disposition", "attachment; filename=" + fileNameWithExt + ";");
        }
        try {
            if (zipped) {
                ZipOutputStream zip = new ZipOutputStream((OutputStream)resp.getOutputStream());
                zip.putNextEntry(new ZipEntry(fileNameWithExt));
                IOUtils.transfer((InputStream)((DataHandler)data.value).getInputStream(), (OutputStream)zip, (int)10240);
                zip.flush();
                zip.close();
            } else {
                IOUtils.transfer((InputStream)((DataHandler)data.value).getInputStream(), (OutputStream)resp.getOutputStream(), (int)10240);
            }
            ((DataHandler)data.value).getInputStream().close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

