/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.collector;

import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceSelector;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.application.server.MethodProperties;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowListener;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.kernel.network.flow.IPFIXArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Array;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.SFlowArray;
import ru.bitel.bgbilling.modules.inet.common.bean.FlowAgentType;
import ru.bitel.bgbilling.modules.inet.server.collector.FlowListenerWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.collector.FlowListenerWorkerContextIPFIX;
import ru.bitel.bgbilling.modules.inet.server.collector.FlowListenerWorkerContextNetflow9;
import ru.bitel.bgbilling.modules.inet.server.collector.InetFlow9Listener;
import ru.bitel.bgbilling.modules.inet.server.collector.InetIPFIXListener;
import ru.bitel.bgbilling.modules.inet.server.collector.InetNetflowListener;
import ru.bitel.bgbilling.modules.inet.server.collector.InetSflowListener;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public abstract class InetFlowListener
extends FlowListener
implements Lifecycle,
CommandListener {
    private static final Logger logger = LogManager.getLogger();
    protected final Setup setup;
    protected final ThreadPoolExecutor executorService;
    private final BlockingQueue<Runnable> workQueue;
    protected final ThreadPoolExecutor fallbackExecutorService;
    private long packetCount = 0L;
    private int currentPacketCount = 0;
    private int packetCountMinute = 0;
    private long currentMinute = System.currentTimeMillis() / 1000L / 60L;
    private int maxQueueSize = 2000;

    protected InetFlowListener(Setup setup, String host, int port, int threadCount, int byteBufferCapacity, int socketRCVBUF, ThreadContextFactory<FlowListenerWorkerContext<? extends FlowArray<?>>> contextFactory) {
        super(host, port, byteBufferCapacity, socketRCVBUF, "collector");
        this.setup = setup;
        this.executorService = (ThreadPoolExecutor)WorkerTask.newFixedThreadPool((String)"flow", null, contextFactory, (int)threadCount);
        this.workQueue = this.executorService.getQueue();
        this.fallbackExecutorService = (ThreadPoolExecutor)WorkerTask.newFixedThreadPool((String)"flow-overload", null, contextFactory, (int)3, (int)1000, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
    }

    public final void flush(long millis, List<FlowPacket> packetList) {
        int overloadLevel;
        int queueSize = this.workQueue.size();
        if (queueSize > 2000) {
            overloadLevel = 3;
            String key = "flow.wait.thread";
            if (AlarmSender.needAlarmSend((String)key, (long)millis, (long)120000L)) {
                String message = "\u0412 \u0440\u0430\u043c\u043a\u0430\u0445 \u043e\u0442\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u043c\u0438 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043f\u043e\u0442\u043e\u043a\u043e\u0432 " + this.getThreadCount() + "=" + this.executorService.getMaximumPoolSize() + " \u0438 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 " + this.maxQueueSize + " Netflow \u043a\u043e\u043b\u043b\u0435\u043a\u0442\u043e\u0440 " + this.port + " \u043d\u0435 \u0443\u0441\u043f\u0435\u0435\u0432\u0430\u0435\u0442 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432.\n\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u0430\u044f \u043f\u0440\u0438\u0447\u0438\u043d\u0430 - \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445.";
                AlarmErrorMessage alarm = new AlarmErrorMessage(key, "Netflow \u043a\u043e\u043b\u043b\u0435\u043a\u0442\u043e\u0440 " + this.port + " \u043d\u0435 \u0443\u0441\u043f\u0435\u0432\u0430\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u044b", message);
                alarm.setDumpStackTrace(true);
                AlarmSender.sendAlarm((AlarmErrorMessage)alarm, (long)millis);
                logger.error("FlowListener queue is full!");
            } else {
                logger.error("FlowListener queue is full!");
            }
        } else {
            overloadLevel = 0;
        }
        this.flush(millis, packetList, overloadLevel);
    }

    public abstract void flush(long var1, List<FlowPacket> var3, int var4);

    protected void updateStat(long millis, List<FlowPacket> packetList) {
        assert (packetList instanceof RandomAccess);
        int size = packetList.size();
        this.packetCount += (long)size;
        long minute = millis / 1000L / 60L;
        if (minute != this.currentMinute) {
            this.packetCountMinute = this.currentPacketCount;
            this.currentMinute = minute;
            this.currentPacketCount = 0;
        } else {
            this.currentPacketCount += size;
        }
    }

    protected void toString(StringBuilder result) {
        ThreadPoolExecutor pool = this.executorService;
        ThreadPoolExecutor fallbackPool = this.fallbackExecutorService;
        if (pool != null) {
            result.append("queue_size: ");
            result.append(pool.getQueue().size());
            result.append("; threads_active: ");
            result.append(pool.getActiveCount());
            result.append("; largest: ");
            result.append(pool.getLargestPoolSize());
            result.append("; core: ");
            result.append(pool.getCorePoolSize());
            result.append("; pool_size: ");
            result.append(pool.getPoolSize());
            result.append("; extra_queue_size: ");
            result.append(fallbackPool.getQueue().size());
            result.append("; ");
        }
        super.toString(result);
        result.append("; packets: ").append(this.packetCount);
    }

    public int getPacketCountMinute() {
        return this.packetCountMinute;
    }

    public static InetFlowListener newInstance(Setup setup, String host, int port, int threadCount, int byteBufferCapacity, int socketRCVBUF, Iterable<InetNas> nasList, final Accounting accounting, final FlowAgentInterfaceSelector ifaceSelector, String processAgentDeviceIdsString, Integer _flowFilter, final IPHourlyDataLogger dataLogger, int agentType, String nasesString) {
        Set _processAgentDeviceIds = Utils.toIntegerSet((String)processAgentDeviceIdsString);
        if (_processAgentDeviceIds.size() == 0) {
            _processAgentDeviceIds = null;
        }
        final Set processAgentDeviceIds = _processAgentDeviceIds;
        if (setup.getInt("flow.filter", setup.getInt("flow.ipResourceFilter", -1)) != -1) {
            _flowFilter = setup.getInt("flow.filter", setup.getInt("flow.ipResourceFilter", -1));
        }
        final int flowFilter = _flowFilter;
        switch (agentType) {
            case 1: {
                ThreadContextFactory contextFactory = new ThreadContextFactory<FlowListenerWorkerContext<?>>(){

                    public FlowListenerWorkerContext<NetFlowArray> newThreadContext() {
                        return new FlowListenerWorkerContext<NetFlowArray>(accounting, ifaceSelector, processAgentDeviceIds, flowFilter, dataLogger, new NetFlowArray(32));
                    }
                };
                return new InetNetflowListener(setup, host, port, threadCount, byteBufferCapacity, socketRCVBUF, contextFactory);
            }
            case 2: {
                final ConcurrentHashMap<Integer, NetFlow9Template> templates = new ConcurrentHashMap<Integer, NetFlow9Template>();
                ThreadContextFactory contextFactory = new ThreadContextFactory<FlowListenerWorkerContext<?>>(){

                    public FlowListenerWorkerContext<NetFlow9Array> newThreadContext() {
                        return new FlowListenerWorkerContextNetflow9(accounting, ifaceSelector, processAgentDeviceIds, flowFilter, dataLogger, new NetFlow9Array(512), templates);
                    }
                };
                return new InetFlow9Listener(setup, host, port, threadCount, byteBufferCapacity, socketRCVBUF, contextFactory, templates);
            }
            case 5: {
                final ConcurrentHashMap<Integer, NetFlow9Template> templates = new ConcurrentHashMap<Integer, NetFlow9Template>();
                ThreadContextFactory contextFactory = new ThreadContextFactory<FlowListenerWorkerContext<?>>(){

                    public FlowListenerWorkerContext<IPFIXArray> newThreadContext() {
                        return new FlowListenerWorkerContextIPFIX(accounting, ifaceSelector, processAgentDeviceIds, flowFilter, dataLogger, new IPFIXArray(512), templates);
                    }
                };
                return new InetIPFIXListener(setup, host, port, threadCount, byteBufferCapacity, socketRCVBUF, contextFactory, templates);
            }
            case 3: {
                ThreadContextFactory contextFactory = new ThreadContextFactory<FlowListenerWorkerContext<?>>(){

                    public FlowListenerWorkerContext<SFlowArray> newThreadContext() {
                        return new FlowListenerWorkerContext<SFlowArray>(accounting, ifaceSelector, processAgentDeviceIds, flowFilter, dataLogger, new SFlowArray(512));
                    }
                };
                return new InetSflowListener(setup, host, port, threadCount, byteBufferCapacity, socketRCVBUF, contextFactory);
            }
        }
        throw new IllegalArgumentException("agentType=" + String.valueOf(agentType));
    }

    @MethodProperties(value={"type", "host", "port", "threadCount", "recvBufferSize", "soRCVBUF", "agentDeviceIds", "processAgentDeviceIds", "ipResourceFilter", "flowFilter", "dataLogger"})
    public static InetFlowListener newInstance(String type, String host, int port, int threadCount, int recvBufferSize, int soRCVBUF, String agentDeviceIds, String processAgentDeviceIds, Integer ipResourceFilter, Integer flowFilter, IPHourlyDataLogger dataLogger) throws BGException, NamingException {
        Context env = DefaultServerSetup.getEnvironment();
        Setup setup = (Setup)env.lookup("setup");
        Accounting accounting = (Accounting)env.lookup("accounting");
        if (dataLogger == null) {
            dataLogger = (IPHourlyDataLogger)env.lookup("flowDataLogger");
        }
        logger.info("Create new FlowListener " + type + " on port " + port + " [recv_buf_size=" + recvBufferSize + "]");
        int agentType = FlowAgentType.nameToType((String)type);
        if (!FlowAgentType.checkSourceType((int)agentType)) {
            logger.error("Incorrect source type=" + type);
            throw new IllegalArgumentException("Incorrect source type=" + type);
        }
        FlowAgentInterfaceSelector ifaceSelector = accounting.ifaceMap.newSelector(Utils.toIntegerSet((String)agentDeviceIds), agentType);
        if (flowFilter == null || flowFilter == 0) {
            flowFilter = ipResourceFilter;
        }
        InetFlowListener l = InetFlowListener.newInstance(setup, host, port, threadCount, recvBufferSize, soRCVBUF, null, accounting, ifaceSelector, processAgentDeviceIds, flowFilter, dataLogger, agentType, null);
        return l;
    }

    public void start() throws Exception {
        this.init();
        this.startListener();
    }

    public void stop() throws Exception {
        this.shutdown();
    }

    public String getCommandsHelp() {
        return "";
    }

    public String executeCommand(String cmd, String param) {
        if ("status".equals(cmd)) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("Flow listener [").append(this.host).append(":").append(this.port).append("]\n  flow packets in current minute: ").append(this.getPacketCountMinute()).append("\n  ");
            ThreadPoolExecutor pool = this.executorService;
            ThreadPoolExecutor fallbackPool = this.fallbackExecutorService;
            sb.append("pool_size: ");
            sb.append(pool.getPoolSize());
            sb.append("; threads_active: ");
            sb.append(pool.getActiveCount());
            sb.append("; queue_size: ");
            sb.append(pool.getQueue().size());
            sb.append("; extra_queue_size: ");
            sb.append(fallbackPool.getQueue().size());
            sb.append("; packets: ").append(this.packetCount);
            return sb.toString();
        }
        return null;
    }

    @MBeanAttribute
    public long getPacketCount() {
        return this.packetCount;
    }

    @MBeanAttribute
    public int getPacketCountPerMinute() {
        return this.packetCountMinute;
    }

    @MBeanAttribute
    public int getThreadCount() {
        return this.executorService.getMaximumPoolSize();
    }

    public void setThreadCount(int count) {
        this.executorService.setCorePoolSize(count);
        this.executorService.setMaximumPoolSize(count);
    }

    @MBeanAttribute
    public int getCurrentThreadCount() {
        return this.executorService.getPoolSize();
    }

    @MBeanAttribute
    public int getActiveThreadCount() {
        return this.executorService.getActiveCount();
    }

    @MBeanAttribute
    public long getTaskCount() {
        return this.executorService.getTaskCount();
    }

    @MBeanAttribute
    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    @MBeanAttribute
    public long getQueueSize() {
        return this.workQueue.size();
    }
}

