/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.ipn.common.CiscoRuleOptions;
import ru.bitel.bgbilling.modules.ipn.server.action.ActionUpdateContractRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.AclOptions;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;
import ru.bitel.common.Preferences;

public class ActionUpdateCiscoContractRule
extends ActionUpdateContractRule {
    @Override
    public void doAction() throws SQLException, BGException {
        int fwid = this.getIntParameter("fwid", -1);
        this.ruleText = this.getParameter("rule");
        if (this.ruleText == null || this.cid < 0 || fwid < 0) {
            throw new BGIllegalArgumentException();
        }
        CiscoRuleOptions ruleOptions = CiscoRuleOptions.extractParams((String)this.ruleText);
        if (ruleOptions.aclId <= 0) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ACL");
        }
        if (ruleOptions.fromPos <= 0) {
            Gate gate = new GateManager(this.con, this.mid).getGateById(fwid);
            UserGateRuleManager ugrm = new UserGateRuleManager(this.con, this.mid);
            if (gate != null) {
                Map<Integer, AclOptions> aclMap = AclOptions.getAclMapById(new Preferences(gate.getConfig(), "\r\n"));
                AclOptions options = aclMap.get(ruleOptions.aclId);
                HashSet<Integer> usedPos = new HashSet<Integer>();
                for (UserGateRule rule : ugrm.getUserGateRulesForGate(fwid)) {
                    CiscoRuleOptions params = CiscoRuleOptions.extractParams((String)rule.getRuleText());
                    if (params.fromPos < options.fromPos) continue;
                    usedPos.add(params.fromPos);
                }
                int pos = options.fromPos;
                while (usedPos.contains(pos)) {
                    pos += options.onContact;
                }
                ruleOptions.fromPos = pos;
                this.ruleText = CiscoRuleOptions.addParams((String)CiscoRuleOptions.clearFromParams((String)this.ruleText), (CiscoRuleOptions)ruleOptions);
            }
        }
        super.doAction();
    }
}

