/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;

public class RadiusLogViewer
extends BGPanel {
    private JTextArea logTa = new JTextArea();
    private Calendar date;

    public RadiusLogViewer() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JButton hideRadiusButton = new JButton("X");
        JPanel radiusHeaderPanel = new JPanel(new GridBagLayout());
        this.logTa.setLineWrap(true);
        this.logTa.setRows(10);
        this.logTa.setWrapStyleWord(true);
        radiusHeaderPanel.add((Component)hideRadiusButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 3, 0), 0, 0));
        radiusHeaderPanel.add(Box.createGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        radiusHeaderPanel.add((Component)new JLabel(" RADIUS log:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)radiusHeaderPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.logTa), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        hideRadiusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RadiusLogViewer.this.setVisible(false);
            }
        });
        this.setPreferredSize(new Dimension(100, 300));
        this.setMinimumSize(new Dimension(100, 300));
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void showLog() {
        Request request = new Request();
        request.setModule("call");
        request.setAction("GetRadiusLogInfo");
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAttribute("id", this.id);
        request.setAttribute("date", TimeUtils.format(this.date, "dd.MM.yyyy"));
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.logTa.setText("");
            Node rootNode = doc.getFirstChild();
            if (rootNode.hasChildNodes()) {
                NodeList list = rootNode.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    Node firstChild = list.item(i).getFirstChild();
                    this.logTa.append(firstChild == null ? "" : firstChild.getNodeValue());
                    this.logTa.append("\n");
                }
            }
        }
    }
}

