/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.client.RequestRecordLogTable;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RecordAction;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RequestRecordLog;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class UserRightMonitoringRecordPanel
extends BGUPanel {
    private RoleService roleService;
    private final BGUComboBox<IdTitle> filter = new BGUComboBox();
    private RequestLogActionsPanel requestLogActionsPanel;
    private RequestRecordLogTable recordLogTable;

    public UserRightMonitoringRecordPanel(ClientContext context) {
        super(context);
    }

    @Override
    protected void jbInit() throws Exception {
        this.requestLogActionsPanel = new RequestLogActionsPanel((ClientContext)this.getContext());
        final JPopupMenu popupMenu = new JPopupMenu();
        final JMenuItem showActions = new JMenuItem("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
        showActions.addActionListener(e -> this.showActionsPanel());
        final JMenuItem stopRecordActions = new JMenuItem("\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
        stopRecordActions.addActionListener(e -> this.performAction("edit"));
        this.recordLogTable = new RequestRecordLogTable((ClientContext)this.getContext());
        this.recordLogTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && UserRightMonitoringRecordPanel.this.recordLogTable.getSelectedRequest() != null) {
                    popupMenu.removeAll();
                    popupMenu.add(showActions);
                    if (UserRightMonitoringRecordPanel.this.recordLogTable.getSelectedRequest().getEndRecordingTime() == null) {
                        popupMenu.add(stopRecordActions);
                    }
                    popupMenu.show(UserRightMonitoringRecordPanel.this.recordLogTable, e.getX(), e.getY());
                }
            }
        });
        BGButton createUserActionsRecord = new BGButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c");
        createUserActionsRecord.addActionListener(e -> new CreateUserActionsRecordDialog());
        this.filter.addItem(new IdTitle(0, "\u0412\u0441\u0435"));
        this.filter.addItem(new IdTitle(1, "\u0412 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435"));
        this.filter.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                try {
                    if (this.filter.getSelectedItem() != null && ((IdTitle)this.filter.getSelectedItem()).getId() > 0) {
                        this.recordLogTable.setData(this.getRoleService().searchRequestRecordLogList().getList().stream().filter(requestRecordLog -> requestRecordLog.getEndRecordingTime() == null).collect(Collectors.toList()));
                    } else {
                        this.recordLogTable.setData(this.getRoleService().searchRequestRecordLogList().getList());
                    }
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)createUserActionsRecord, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c:"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 0, 5), 0, 0));
        this.add(this.filter, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.recordLogTable), new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.requestLogActionsPanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void showActionsPanel() {
        Set<RecordAction> actions = this.recordLogTable.getSelectedRequest().getActions();
        if (Utils.isEmptyCollection(actions)) {
            return;
        }
        this.requestLogActionsPanel.showPanel(actions);
    }

    private RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = ((ClientContext)this.getContext()).getPort(RoleService.class);
        }
        return this.roleService;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            this.recordLogTable.setData(this.getRoleService().searchRequestRecordLogList().getList());
            if (this.requestLogActionsPanel.isVisible()) {
                this.requestLogActionsPanel.setVisible(false);
            }
        });
        new AbstractBGUPanel.BGActionNew(e -> new CreateUserActionsRecordDialog());
        new AbstractBGUPanel.BGActionEdit(e -> {
            RequestRecordLog requestRecordLog = this.recordLogTable.getSelectedRequest();
            if (requestRecordLog != null) {
                if (requestRecordLog.getEndRecordingTime() == null) {
                    if (ClientUtils.confirm("\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f?", "\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c")) {
                        this.getRoleService().stopRecordingActions(requestRecordLog.getUserId());
                        this.performAction("refresh");
                    }
                } else {
                    ClientUtils.showMessageDialog("\u0414\u0430\u043d\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0438 \u043d\u0435 \u043f\u043e\u0434\u043b\u0435\u0436\u0438\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044e");
                }
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            RequestRecordLog record = this.recordLogTable.getSelectedRequest();
            if (record == null) {
                ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete(record.getTitle())) {
                ((ClientContext)this.getContext()).getWebService(RoleService.class, 0).deleteRequestRecordLog(record);
                this.performAction("refresh");
            }
        });
    }

    private final class RequestLogActionsPanel
    extends JPanel {
        private final ActionsTableModel actionsTableModel;

        public RequestLogActionsPanel(ClientContext clientContext) {
            this.actionsTableModel = new ActionsTableModel(clientContext);
            this.setLayout(new GridBagLayout());
            this.setVisible(false);
            BGSwingUtilites.wrapEmptyBorder(this);
            BGToolBar toolBar = new BGToolBar();
            toolBar.add(new BGUAction("remove", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435", (Icon)ClientUtils.getIcon("delete")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        RequestRecordLog openedRecordLog = UserRightMonitoringRecordPanel.this.recordLogTable.getSelectedRequest();
                        openedRecordLog.getActions().remove(RequestLogActionsPanel.this.actionsTableModel.getSelectedRow());
                        UserRightMonitoringRecordPanel.this.getRoleService().updateRequestLog(openedRecordLog);
                        UserRightMonitoringRecordPanel.this.recordLogTable.setData(UserRightMonitoringRecordPanel.this.getRoleService().searchRequestRecordLogList().getList());
                        RequestLogActionsPanel.this.actionsTableModel.setData(new ArrayList<RecordAction>(openedRecordLog.getActions()));
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            });
            BGButton hidePanel = new BGButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
            hidePanel.addActionListener(e -> this.setVisible(false));
            BGUTable actionsTable = new BGUTable(this.actionsTableModel);
            actionsTable.setSelectionMode(0);
            this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JScrollPane(actionsTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)hidePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 14, 0, new Insets(3, 3, 3, 3), 0, 0));
        }

        private void showPanel(Set<RecordAction> actions) {
            this.actionsTableModel.setData(new ArrayList<RecordAction>(actions));
            this.setVisible(true);
        }
    }

    private final class CreateUserActionsRecordDialog
    extends BGDialog {
        public CreateUserActionsRecordDialog() {
            this.getContentPane().setLayout(new GridBagLayout());
            Dimension dimension = new Dimension(500, 300);
            this.setSize(dimension);
            this.setMaximumSize(dimension);
            this.setPreferredSize(dimension);
            this.setDefaultCloseOperation(1);
            this.setTitle("\u0417\u0430\u043f\u0438\u0441\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
            this.add((Component)this.createSettingsPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.pack();
            this.moveWindowToCenterScreen();
            this.setVisible(true);
        }

        private JPanel createSettingsPanel() {
            JTextField title = new JTextField();
            BGUComboBox<User> users = new BGUComboBox<User>();
            try {
                users.setData(this.getContext().getPort(UserService.class).listUsers());
            }
            catch (BGException e2) {
                ClientUtils.showErrorMessageDialog(e2);
            }
            BGButton apply = new BGButton("\u041d\u0430\u0447\u0430\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
            apply.addActionListener(e -> {
                try {
                    User selectedUser = (User)users.getSelectedItem();
                    if (selectedUser == null) {
                        BGToolTip.showErrorMessage(users, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c!");
                        return;
                    }
                    if (Utils.isBlankString(title.getText())) {
                        BGToolTip.showErrorMessage(title, "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                        return;
                    }
                    UserRightMonitoringRecordPanel.this.getRoleService().startRecordingActions(selectedUser.getId(), title.getText());
                    this.setVisible(false);
                    UserRightMonitoringRecordPanel.this.performAction("refresh");
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog(ex.getMessage());
                }
            });
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), constraints);
            panel.add((Component)title, constraints);
            panel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"), constraints);
            panel.add(users, constraints);
            constraints.weighty = 1.0;
            constraints.anchor = 16;
            panel.add((Component)apply, constraints);
            return panel;
        }
    }

    private static final class ActionsTableModel
    extends BGTableModel<RecordAction> {
        private List<BGModule> moduleList;
        private List<BGInstalledModule> pluginList;

        public ActionsTableModel(ClientContext clientContext) {
            super("Actions");
            try {
                ModuleService moduleService = clientContext.getWebService(ModuleService.class);
                this.moduleList = moduleService.moduleList();
                this.pluginList = moduleService.installedPluginList();
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "description", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", 50, 50, -1, "moduleId", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0435\u0440\u0432\u0438\u0441", 150, 150, -1, "service", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435", 150, 150, -1, "operation", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValueAt(RecordAction val, int column) throws BGException {
            if (column == 1) {
                String moduleName = "";
                String moduleId = Utils.maskBlank(val.getModuleId(), "");
                if ("0".equals(moduleId)) {
                    moduleName = "\u042f\u0434\u0440\u043e";
                } else {
                    if (moduleId.contains("p") && Utils.notEmptyCollection(this.moduleList)) {
                        String pluginId = moduleId.replace("p", "");
                        Optional<BGInstalledModule> plugin = this.pluginList.stream().filter(p -> p.getId() == Utils.parseInt(pluginId, 0)).findFirst();
                        return plugin.isPresent() ? plugin.get().getTitle() : moduleId;
                    }
                    if (Utils.notEmptyCollection(this.moduleList)) {
                        Optional<BGModule> module = this.moduleList.stream().filter(m -> m.getId() == Utils.parseInt(moduleId, 0)).findFirst();
                        return module.isPresent() ? module.get().getTitle() : moduleId;
                    }
                }
                return moduleName;
            }
            return super.getValueAt(val, column);
        }
    }
}

