/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class ContractTariffDao
extends AbstractIdDao<ContractTariff> {
    public ContractTariffDao(Connection con) {
        super(con, 0, "contract_tariff");
    }

    @Override
    protected ContractTariff getFromRS(ResultSet rs) throws SQLException, BGException {
        return ContractTariff.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setPeriod(new Period(TimeUtils.convertSqlDateToDate(rs.getDate("date1")), TimeUtils.convertSqlDateToDate(rs.getDate("date2")))).setTariffPlanId(rs.getInt("tpid")).setTariffGroupId(rs.getInt("tariff_group_id")).setComment(rs.getString("comment")).setPosition(rs.getInt("pos")).setEntityModuleId(rs.getInt("emid")).setEntityId(rs.getInt("eid")).setReplacedFromContractTariffId(rs.getInt("replaced_from")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateImpl(ContractTariff contractTariff) throws BGException, SQLException {
        block45: {
            Statement st;
            boolean insert = contractTariff.getId() < 1;
            String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET cid=?, date1=?, date2=?, tpid=?, comment=?, pos=?, emid=?, eid=?, replaced_from=?, tariff_group_id=?" + (insert ? "" : " WHERE id=?");
            try {
                st = this.con.createStatement();
                try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                    int count = -1;
                    if (contractTariff.getReplacedFromContractTariffId() > 0) {
                        st.executeUpdate("LOCK TABLES " + this.tableName + " WRITE");
                        try (PreparedStatement psSelect = this.con.prepareStatement("SELECT count(*) FROM " + this.tableName + " WHERE replaced_from=?" + (insert ? "" : " AND id<>?"));){
                            psSelect.setInt(1, contractTariff.getReplacedFromContractTariffId());
                            if (!insert) {
                                psSelect.setInt(2, contractTariff.getId());
                            }
                            try (ResultSet rs = psSelect.executeQuery();){
                                while (rs.next()) {
                                    count = rs.getInt(1);
                                }
                            }
                        }
                    }
                    if (count < 1) {
                        int parameterIndex = 1;
                        ps.setInt(parameterIndex++, contractTariff.getContractId());
                        ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate(contractTariff.getPeriod().getDateFrom()));
                        ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate(contractTariff.getPeriod().getDateTo()));
                        ps.setInt(parameterIndex++, contractTariff.getTariffPlanId());
                        ps.setString(parameterIndex++, contractTariff.getComment());
                        ps.setInt(parameterIndex++, contractTariff.getPosition());
                        ps.setInt(parameterIndex++, contractTariff.getEntityMid());
                        ps.setInt(parameterIndex++, contractTariff.getEntityId());
                        ps.setInt(parameterIndex++, contractTariff.getReplacedFromContractTariffId());
                        ps.setInt(parameterIndex++, contractTariff.getTariffGroupId());
                        if (!insert) {
                            ps.setInt(parameterIndex++, contractTariff.getId());
                        }
                        ps.executeUpdate();
                        if (insert) {
                            contractTariff.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                        }
                        break block45;
                    }
                    throw new BGException("\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043c\u0435\u043d\u044b \u0442\u0430\u0440\u0438\u0444\u0430");
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            finally {
                if (contractTariff.getReplacedFromContractTariffId() > 0) {
                    st = this.con.createStatement();
                    try {
                        st.executeUpdate("UNLOCK TABLES");
                    }
                    finally {
                        if (st != null) {
                            st.close();
                        }
                    }
                }
            }
        }
    }

    public List<ContractTariff> list(int contractId, LocalDate date) throws BGException {
        return this.list(contractId, date, 0, 0);
    }

    public List<ContractTariff> list(int contractId, LocalDate date, int emid, int eid) throws BGException {
        ArrayList<ContractTariff> result = new ArrayList<ContractTariff>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND " + (String)(emid >= 0 ? "emid=" + emid + " AND eid=" + eid : "emid=0 AND eid=0") + " AND ( ? IS NULL OR (( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )) ) ORDER BY date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Date sqlDate = TimeUtils.convertLocalDateToSqlDate(date);
            ps.setInt(1, contractId);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public ContractTariff getFirst(int contractId, LocalDate date) throws BGException {
        List<ContractTariff> list = this.list(contractId, date);
        return list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public int delete(int id) throws BGException {
        String query = "DELETE FROM contract_tariff_vars WHERE contract_tariff_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return super.delete(id);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean checkDoubleTariffForContract(int contractId, int tpid, LocalDate date1, LocalDate date2) {
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND tpid=? AND (date1 IS NULL OR ? IS NULL OR date1<=?) AND (date2 IS NULL OR ? IS NULL OR ?<=date2)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            boolean bl;
            block14: {
                int index = 1;
                ps.setInt(index++, contractId);
                ps.setInt(index++, tpid);
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate(date2));
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate(date2));
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate(date1));
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate(date1));
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public List<ContractTariffVar> getContractTariffVars(int contractTariffId) throws BGException {
        ContractTariff contractTariff = (ContractTariff)this.get(contractTariffId);
        boolean addContractTariffVar = contractTariff != null;
        ArrayList<ContractTariffVar> list = new ArrayList<ContractTariffVar>();
        String query = "SELECT * FROM tariff_vars AS tv" + (addContractTariffVar ? " LEFT JOIN  contract_tariff_vars AS ctv ON ctv.tariff_var_id=tv.id AND ctv.contract_tariff_id=? WHERE tv.tariff_id IN ( ?, 0 )" : "");
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            if (addContractTariffVar) {
                psSelect.setInt(1, contractTariffId);
                psSelect.setInt(2, contractTariff.getTariffPlanId());
            }
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    int topId = rs.getInt("top_id");
                    String defaultValue = rs.getString("default_value");
                    String parentDefaultvalue = rs.getString("parent_default_value");
                    ContractTariffVar contractTariffVar = new ContractTariffVar();
                    contractTariffVar.setId(rs.getInt("id"));
                    contractTariffVar.setTariffPlanId(rs.getInt("tariff_id"));
                    contractTariffVar.setType(TariffVarType.getTariffVarTypeByCode(rs.getString("type")));
                    contractTariffVar.setModuleId(rs.getInt("module_id"));
                    contractTariffVar.setTitle(rs.getString("title"));
                    contractTariffVar.setDefaultValue(topId > 0 && defaultValue.isEmpty() ? parentDefaultvalue : defaultValue);
                    contractTariffVar.setContractTarifffId(contractTariffId);
                    if (addContractTariffVar) {
                        contractTariffVar.setValue(rs.getString("value"));
                    }
                    list.add(contractTariffVar);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return list;
    }

    public ContractTariffVar getContractTariffVar(int contractTariffId, int tariffVarId) throws BGException {
        ContractTariffVar contractTariffVar = null;
        ContractTariff contractTariff = (ContractTariff)this.get(contractTariffId);
        if (contractTariff != null) {
            String query = "SELECT * FROM tariff_vars AS tv LEFT JOIN  contract_tariff_vars AS ctv ON ctv.tariff_var_id=tv.id AND ctv.contract_tariff_id=? WHERE tv.id=?";
            try (PreparedStatement psSelect = this.con.prepareStatement(query);){
                psSelect.setInt(1, contractTariff.getTariffPlanId());
                psSelect.setInt(2, tariffVarId);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        contractTariffVar = new ContractTariffVar();
                        contractTariffVar.setId(rs.getInt("id"));
                        contractTariffVar.setTariffPlanId(rs.getInt("tariff_id"));
                        contractTariffVar.setType(TariffVarType.getTariffVarTypeByCode(rs.getString("type")));
                        contractTariffVar.setModuleId(rs.getInt("module_id"));
                        contractTariffVar.setTitle(rs.getString("title"));
                        contractTariffVar.setDefaultValue(rs.getString("default_value"));
                        contractTariffVar.setValue(rs.getString("value"));
                        contractTariffVar.setContractTarifffId(contractTariffId);
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
        return contractTariffVar;
    }

    public void updateContractTariffVar(ContractTariffVar contractTariffVar) throws BGException {
        Objects.requireNonNull(contractTariffVar);
        try (PreparedStatement psUpdate = this.con.prepareStatement("UPDATE contract_tariff_vars SET value=? WHERE tariff_var_id=? AND contract_tariff_id=?");
             PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO contract_tariff_vars SET tariff_var_id=?, contract_tariff_id=?, value=?");){
            psUpdate.setString(1, contractTariffVar.getValue());
            psUpdate.setInt(2, contractTariffVar.getId());
            psUpdate.setInt(3, contractTariffVar.getContractTarifffId());
            if (psUpdate.executeUpdate() == 0) {
                psInsert.setInt(1, contractTariffVar.getId());
                psInsert.setInt(2, contractTariffVar.getContractTarifffId());
                psInsert.setString(3, contractTariffVar.getValue());
                psInsert.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void deleteContractTariffVar(ContractTariffVar contractTariffVar) throws BGException {
        Objects.requireNonNull(contractTariffVar);
        try (PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM contract_tariff_vars WHERE tariff_var_id=? AND contract_tariff_id=?");){
            psDelete.setInt(1, contractTariffVar.getId());
            psDelete.setInt(2, contractTariffVar.getContractTarifffId());
            psDelete.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void deleteContractTariffs(int contractId) throws SQLException {
        String query = "DELETE tv FROM contract_tariff_vars tv JOIN " + this.tableName + " ct ON ct.id=tv.contract_tariff_id WHERE ct.cid=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(query);){
            psDelete.setInt(1, contractId);
            psDelete.executeUpdate();
        }
        query = "DELETE FROM " + this.tableName + " WHERE cid=?";
        psDelete = this.con.prepareStatement(query);
        try {
            psDelete.setInt(1, contractId);
            psDelete.executeUpdate();
        }
        finally {
            if (psDelete != null) {
                psDelete.close();
            }
        }
    }
}

