/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.list.renderer.TitleIdListCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.pattern.client.ContractPatternObjectsTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternGeneralPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternLabelAndGroupTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternPluginTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternScriptTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternTariffTabPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class PatternEditor
extends BGTabPanel
implements AbstractTabPanel {
    public static final String TAB_ID = "patternEditor";
    protected int patternId = -1;
    private BGUList<IdTitle> patternList;
    private JPanel rightPanel = new JPanel();
    private CardLayout rightPanelLayout = new CardLayout();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGTextField patternTitle = new BGTextField();

    public PatternEditor() {
        super(TAB_ID, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        this.module = "contract";
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setData();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getListPanel(), (Component)this.getRightPanel(), 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getRightPanel() {
        this.patternTitle.setMinimumSize(new Dimension(165, 24));
        this.patternTitle.setPreferredSize(new Dimension(165, 24));
        this.patternTitle.setColumns(15);
        JPanel noSelectPanel = new JPanel(new GridBagLayout());
        noSelectPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", 0), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 30, 0, 30), 0, 0));
        Document moduleDoc1 = ClientUtils.getModuleDoc(this.getClass());
        this.tabbedPane.add((Component)new PatternGeneralPanel(moduleDoc1), "\u041e\u0431\u0449\u0438\u0435");
        this.tabbedPane.add((Component)new PatternModuleTabPanel(moduleDoc1), "\u041c\u043e\u0434\u0443\u043b\u0438");
        this.tabbedPane.add((Component)new PatternPluginTabPanel(moduleDoc1), "\u041f\u043b\u0430\u0433\u0438\u043d\u044b");
        this.tabbedPane.add((Component)new PatternLabelAndGroupTabPanel(moduleDoc1), "\u041c\u0435\u0442\u043a\u0438, \u0433\u0440\u0443\u043f\u043f\u044b");
        this.tabbedPane.add((Component)new PatternTariffTabPanel(moduleDoc1), "\u0413\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u0438 \u0442\u0430\u0440\u0438\u0444\u044b");
        this.tabbedPane.add((Component)new PatternScriptTabPanel(moduleDoc1), "\u0421\u043a\u0440\u0438\u043f\u0442 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f");
        this.tabbedPane.add((Component)new ContractPatternObjectsTabPanel(moduleDoc1), "\u041e\u0431\u044a\u0435\u043a\u0442\u044b");
        this.tabbedPane.addChangeListener(e -> ((PatternBaseTabPanel)this.tabbedPane.getSelectedComponent()).initUI());
        JPanelWithTitleBorder patternTitlePanel = new JPanelWithTitleBorder(" \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 ");
        patternTitlePanel.add((Component)this.patternTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)patternTitlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButtonPanelRestoreOkCancelHelp okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        okCancelPanel.addActionListener(e -> this.okCancel_actionPerformed(e));
        JPanel patternSelectedPanel = new JPanel(new GridBagLayout());
        patternSelectedPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        patternSelectedPanel.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        patternSelectedPanel.add((Component)okCancelPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.rightPanel.setLayout(this.rightPanelLayout);
        this.rightPanel.add((Component)noSelectPanel, "info");
        this.rightPanel.add((Component)patternSelectedPanel, "editor");
        return this.rightPanel;
    }

    private JPanel getListPanel() {
        this.patternList = new BGUList();
        this.patternList.setSelectionMode(0);
        this.patternList.setCellRenderer(new TitleIdListCellRenderer());
        this.patternList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PatternEditor.this.editItem();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.patternList);
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PatternEditor.this.patternList.setFixedCellWidth(PatternEditor.this.patternList.getParent().getWidth() - 20);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0428\u0430\u0431\u043b\u043e\u043d\u044b "));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    public void setData() {
        if (this.patternList.isEnabled()) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ShowPattern");
            request.setAttribute("pid", this.patternId);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                ArrayList<IdTitle> list = new ArrayList<IdTitle>();
                for (Element itemElement : XMLUtils.selectElements(doc, "/data/patterns/item")) {
                    list.add(new IdTitle(Utils.parseInt(itemElement.getAttribute("id")), itemElement.getAttribute("title")));
                }
                this.patternList.setData(list);
                this.patternList.setFixedCellWidth(this.patternList.getParent().getWidth() - 20);
                for (int index = 0; index < this.tabbedPane.getComponentCount(); ++index) {
                    ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).setData(doc);
                }
            }
        } else {
            this.getPatternData();
        }
    }

    protected void getPatternData() {
        if (this.patternId == -1) {
            this.patternTitle.setText("\u041d\u043e\u0432\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            for (int index = 0; index < this.tabbedPane.getComponentCount(); ++index) {
                ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).resetData();
            }
        } else {
            try {
                ContractPattern contractPattern = this.getContext().getWebService(ContractService.class, 0).contractPatternGet(this.patternId);
                this.patternTitle.setText(contractPattern.getTitle());
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("GetPatternInfo");
                request.setAttribute("pid", this.patternId);
                Document doc = this.getDocument(request);
                if (!ClientUtils.checkStatus(doc)) {
                    return;
                }
                Element pattern = XMLUtils.selectElement(doc, "//pattern");
                for (int index = 0; index < this.tabbedPane.getComponentCount(); ++index) {
                    ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).setPatternData(pattern);
                    ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).setPatternData(contractPattern);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    @Override
    public void newItem() {
        if (this.patternList.isEnabled()) {
            this.patternId = -1;
            this.getPatternData();
            this.rightPanelLayout.show(this.rightPanel, "editor");
            this.patternList.setEnabled(false);
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    @Override
    public void editItem() {
        if (this.patternList.isEnabled()) {
            IdTitle item = (IdTitle)this.patternList.getSelectedValue();
            if (item != null) {
                this.patternId = item.getId();
                this.getPatternData();
                this.rightPanelLayout.show(this.rightPanel, "editor");
                this.patternList.setEnabled(false);
                this.tabbedPane.setSelectedIndex(0);
            } else {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d");
            }
        }
    }

    @Override
    public void deleteItem() {
        if (this.patternList.isEnabled()) {
            IdTitle item = (IdTitle)this.patternList.getSelectedValue();
            if (item != null) {
                if (ClientUtils.confirmDelete(item.getTitle())) {
                    try {
                        this.getContext().getWebService(ContractService.class, 0).contractPatternDelete(item.getId());
                        this.rightPanelLayout.show(this.rightPanel, "info");
                        this.patternList.setEnabled(true);
                        this.setData();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            } else {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d");
            }
        }
    }

    private void okCancel_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.getPatternData();
        } else if ("ok".equals(actionCommand)) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateContractPattern");
            request.setAttribute("pid", this.patternId);
            request.setAttribute("title", this.patternTitle.getText().trim());
            boolean result = true;
            for (int index = 0; index < this.tabbedPane.getComponentCount(); ++index) {
                try {
                    result = ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).setRequestData(request);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                    result = false;
                }
                if (!result) break;
            }
            if (result && ClientUtils.checkStatus(this.getDocument(request))) {
                this.rightPanelLayout.show(this.rightPanel, "info");
                this.patternList.setEnabled(true);
                this.setData();
            }
        } else if ("cancel".equals(actionCommand)) {
            this.rightPanelLayout.show(this.rightPanel, "info");
            this.patternList.setEnabled(true);
        }
    }

    class JPanelWithTitleBorder
    extends JPanel {
        public JPanelWithTitleBorder(String borderTitle) {
            super(new GridBagLayout());
            this.setBorder(new BGTitleBorder(borderTitle));
        }
    }
}

