/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamBankEditorDialog;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamCommonPanel;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamEditorData;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamPanel;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamTextArea;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamTextField;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContactType;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerEmployee;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class CustomerParamUPanel
extends CustomerParamCommonPanel {
    private CustomerParamTextField fio = null;
    private CustomerParamTextField inn = null;
    private CustomerParamTextField kpp = null;
    private CustomerParamTextField post = null;
    private CustomerParamTextField ogrn = null;
    private CustomerParamTextArea acts = null;
    private CustomerParamTextArea name = null;
    private CustomerParamTextArea uAddress = null;
    private CustomerBankField bank = null;
    private EmployeeTableModel employeeTableModel = new EmployeeTableModel();

    public CustomerParamUPanel(CustomerParamPanel customerParamPanel) {
        super(customerParamPanel);
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridLayout(1, 3));
        this.add(this.getU1Panel());
        this.add(this.getU2Panel());
        this.add(this.getContactEmployeePanel());
    }

    protected JTabbedPane getContactEmployeePanel() {
        JTabbedPane contactEmployeePanel = new JTabbedPane();
        contactEmployeePanel.add("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b", this.getContactsPanel(false, CustomerContactType.PHONE, CustomerContactType.EMAIL));
        contactEmployeePanel.add("\u0421\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0438", this.getEmployeePanel());
        return contactEmployeePanel;
    }

    private JPanel getEmployeePanel() {
        BGUTable table = new BGUTable(this.employeeTableModel);
        table.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getEmployeeTopPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 0, 3), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, this, "item.edit");
        return panel;
    }

    private JPanel getEmployeeTopPanel() {
        BGToolBar toolBar = new BGToolBar(true);
        toolBar.add(this.getActionMap().get("item.add"));
        toolBar.add(this.getActionMap().get("item.edit"));
        toolBar.add(this.getActionMap().get("item.delete"));
        BGTextField employeeFilter = new BGTextField(20);
        employeeFilter.setPromptText("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430\u043c...", true, true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)employeeFilter, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 30, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getU1Panel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("\u041a\u043b\u0438\u0435\u043d\u0442"));
        panel.add((Component)this.getU1aPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getU1bPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getU1cPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getU1dPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getU1aPanel() {
        this.name = new CustomerParamTextArea(Customer.CustomerJur.NAME.description(), 2, 30, Customer.CustomerJur.NAME.key(), null, this.customerParamPanel);
        return this.wrapTextArea(this.name);
    }

    private JPanel getU1bPanel() {
        this.inn = new CustomerParamTextField(Customer.CustomerJur.INN.description(), 12, Customer.CustomerJur.INN.key(), this.clientSetup.get("dbinfo.customer.u.inn.regexp", "^(\\.{0}|[0-9]{10}|[0-9]{12})$"), this.customerParamPanel);
        this.kpp = new CustomerParamTextField(Customer.CustomerJur.KPP.description(), 10, Customer.CustomerJur.KPP.key(), this.clientSetup.get("dbinfo.customer.u.kpp.regexp", "^(\\.{0}|[0-9]{9})$"), this.customerParamPanel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.inn.getTitle() + ":"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.inn, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)new JLabel(this.kpp.getTitle() + ":"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.kpp, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getU1cPanel() {
        this.ogrn = new CustomerParamTextField(Customer.CustomerJur.OGRN.description(), 20, Customer.CustomerJur.OGRN.key(), this.clientSetup.get("dbinfo.customer.u.ogrn.regexp", "^[0-9]{13}$"), this.customerParamPanel);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.ogrn.getTitle() + ":"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.ogrn, new GridBagConstraints(gridx, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getU1dPanel() {
        this.uAddress = new CustomerParamTextArea(Customer.CustomerJur.ADDRESS.description(), 2, 30, Customer.CustomerJur.ADDRESS.key(), null, this.customerParamPanel);
        return this.wrapTextArea(this.uAddress);
    }

    private JPanel getU2Panel() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getBankPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
        panel.add((Component)this.getU2R2Panel(), new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getBankPanel() {
        this.bank = new CustomerBankField();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("\u0411\u0430\u043d\u043a"));
        panel.add((Component)this.bank, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)new BankEditButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getU2R2Panel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c"));
        panel.add((Component)this.getU2R2aPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 3, 5), 0, 0));
        panel.add((Component)this.getU2R2bPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.getU2R2cPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getU2R2aPanel() {
        this.post = new CustomerParamTextField(Customer.CustomerJurDirector.POSITION.description(), 20, Customer.CustomerJurDirector.POSITION.key(), null, this.customerParamPanel);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.post.getTitle() + ":"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
        panel.add((Component)this.post, new GridBagConstraints(gridx, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 0), 0, 0));
        return panel;
    }

    private JPanel getU2R2bPanel() {
        this.fio = new CustomerParamTextField(Customer.CustomerJurDirector.NAME.description(), 20, Customer.CustomerJurDirector.NAME.key(), null, this.customerParamPanel);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.fio.getTitle() + ":"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
        panel.add((Component)this.fio, new GridBagConstraints(gridx, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 0), 0, 0));
        return panel;
    }

    private JPanel getU2R2cPanel() {
        this.acts = new CustomerParamTextArea(Customer.CustomerJurDirector.REASON.description(), 2, 30, Customer.CustomerJurDirector.REASON.key(), null, this.customerParamPanel);
        return this.wrapTextArea(this.acts);
    }

    public void setData() {
        this.fio.setData();
        this.inn.setData();
        this.kpp.setData();
        this.post.setData();
        this.ogrn.setData();
        this.acts.setData();
        this.name.setData();
        this.bank.setData();
        this.uAddress.setData();
        this.contacts.forEach(CustomerParamCommonPanel.CustomerContactField::setData);
        this.setEmployeeData();
    }

    public void setEmployeeData() {
        Object object = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery("/customer/employee");
        if (object instanceof JSONArray) {
            JSONArray employeeArray = (JSONArray)object;
            ArrayList employees = new ArrayList();
            employeeArray.forEach(item -> {
                if (item instanceof JSONObject) {
                    JSONObject data = (JSONObject)item;
                    employees.add(CustomerEmployee.fromJSON(data));
                }
            });
            this.employeeTableModel.setData(employees);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEnabledForContainer(this, enabled);
    }

    private void setEnabledForContainer(JPanel container, boolean enabled) {
        for (Component component : container.getComponents()) {
            component.setEnabled(enabled);
            if (!(component instanceof JPanel)) continue;
            this.setEnabledForContainer((JPanel)component, enabled);
        }
    }

    private JSONArray getBankData() {
        Object obj = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery("/customer/banks");
        JSONArray banks = obj instanceof JSONArray ? (JSONArray)obj : new JSONArray();
        obj = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery("/customer/bank");
        if (obj instanceof JSONObject) {
            JSONObject bank = (JSONObject)obj;
            bank.put("accountR", (Object)bank.optString("account"));
            bank.remove("account");
            banks.put((Object)bank);
        }
        return banks;
    }

    @Override
    protected void initActions() {
        super.initActions();
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("bank.editor", "", e -> {
            CustomerParamEditorData data = new CustomerParamEditorData();
            data.setCustomerParamPanel(this.customerParamPanel);
            data.setParameterTitle("\u0411\u0430\u043d\u043a");
            data.setClientContext((ClientContext)this.getContext());
            data.setData(this.getBankData());
            new CustomerParamBankEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", data).open();
            this.bank.setData();
        });
        new AbstractBGUPanel.BGActionItemAdd(e -> {
            EmployeeEditorDialog employeeEditorDialog = new EmployeeEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a", new CustomerEmployee());
            employeeEditorDialog.open();
            employeeEditorDialog.optData().ifPresent(data -> {
                this.employeeTableModel.addRow(data);
                this.updateCustomerEmployee((CustomerEmployee)data);
            });
        });
        new AbstractBGUPanel.BGActionItemEdit(e -> this.employeeTableModel.optSelectedRow().ifPresentOrElse(item -> {
            EmployeeEditorDialog employeeEditorDialog = new EmployeeEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430", (CustomerEmployee)item);
            employeeEditorDialog.open();
            employeeEditorDialog.optData().ifPresent(data -> this.updateCustomerEmployee((CustomerEmployee)data));
        }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430")));
        new AbstractBGUPanel.BGActionItemDelete(e -> this.employeeTableModel.optSelectedRow().ifPresent(item -> {
            if (ClientUtils.confirmDelete("\u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430")) {
                try {
                    JSONObject customer = ((ClientContext)this.customerParamPanel.getContext()).getCustomer();
                    customer.put("customer", (Object)new JSONObject(this.customerParamPanel.getCustomerService().customerEmployeeDelete(((ClientContext)this.getContext()).getCustomerId(), item.getUuid())));
                    this.employeeTableModel.deleteRow(item);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        }));
    }

    public void updateCustomerEmployee(CustomerEmployee customerEmployee) {
        try {
            JSONObject customer = ((ClientContext)this.customerParamPanel.getContext()).getCustomer();
            customer.put("customer", (Object)new JSONObject(this.customerParamPanel.getCustomerService().customerEmployeeUpdate(((ClientContext)this.getContext()).getCustomerId(), customerEmployee)));
            this.setEmployeeData();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    class CustomerBankField
    extends JTextField {
        public CustomerBankField() {
            Color bgColor = this.getBackground();
            this.setEditable(false);
            this.setBackground(bgColor);
        }

        public void setData() {
            JSONArray data = CustomerParamUPanel.this.getBankData();
            StringBuilder txt = new StringBuilder();
            if (data != null && data.length() > 0) {
                JSONObject entity = data.optJSONObject(0);
                txt.append(entity.optString("name")).append(" [").append(entity.optString("accountR")).append("]");
            }
            this.setText(txt.toString());
        }
    }

    class EmployeeTableModel
    extends BGTableModel<CustomerEmployee> {
        public EmployeeTableModel() {
            super(EmployeeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0421\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a", -1, -1, -1, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(CustomerEmployee val, int column) throws BGException {
            return String.format("(%s) %s", val.getPosition(), val.getFio());
        }
    }

    class BankEditButton
    extends JButton {
        public BankEditButton() {
            this.setMargin(new Insets(0, 3, 0, 3));
            this.setAction(CustomerParamUPanel.this.getActionMap().get("bank.editor"));
            this.setIcon(ClientUtils.getIcon("edit"));
        }
    }

    static class EmployeeEditorDialog
    extends BGEditorDialog<CustomerEmployee> {
        private final JTextField fio = new JTextField(30);
        private final JTextField position = new JTextField(30);
        private final JTextField phone = new JTextField(30);
        private final JTextField mobile = new JTextField(30);
        private final JTextField email = new JTextField(30);
        private final JTextField address = new JTextField(30);
        private final BGControlPanelDateNoB birthday = new BGControlPanelDateNoB();
        private final JTextField documentSerial = new JTextField(10);
        private final JTextField documentNumber = new JTextField(20);
        private final JTextField documentWhoGive = new JTextField(30);
        private final BGControlPanelDateNoB documentWhenGive = new BGControlPanelDateNoB();
        private BGControlPanelPeriod panelPeriod = new BGControlPanelPeriod();
        private final BGTextArea comment = new BGTextArea(3, 30);

        public EmployeeEditorDialog(String title, CustomerEmployee data) {
            super(title, data);
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)this.getBasePanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getExtPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 15, 0, 0), 0, 0));
            this.position.setText(((CustomerEmployee)this.data).getPosition());
            this.fio.setText(((CustomerEmployee)this.data).getFio());
            this.phone.setText(((CustomerEmployee)this.data).getPhone());
            this.mobile.setText(((CustomerEmployee)this.data).getMobile());
            this.email.setText(((CustomerEmployee)this.data).getEmail());
            this.address.setText(((CustomerEmployee)this.data).getAddress());
            this.birthday.setLocalDate(((CustomerEmployee)this.data).getBirthday());
            this.documentSerial.setText(((CustomerEmployee)this.data).getDocumentSerial());
            this.documentNumber.setText(((CustomerEmployee)this.data).getDocumentNumber());
            this.documentWhoGive.setText(((CustomerEmployee)this.data).getDocumentWhoGive());
            this.documentWhenGive.setLocalDate(((CustomerEmployee)this.data).getDocumentWhenGive());
            this.comment.setText(((CustomerEmployee)this.data).getComment());
            this.panelPeriod.setLocalDateFrom(((CustomerEmployee)this.data).getDateFrom());
            this.panelPeriod.setLocalDateTo(((CustomerEmployee)this.data).getDateTo());
        }

        private JPanel getBasePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.panelPeriod, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.position, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0424\u0418\u041e:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.fio, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.birthday, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getExtPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.phone, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.mobile, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("E-mail:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.email, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.address, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)this.getDocumentPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u0435\u043c \u0432\u044b\u0434\u0430\u043d:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.documentWhoGive, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438:"), new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.documentWhenGive, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getDocumentPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0421\u0435\u0440\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.documentSerial, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.documentNumber, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(2, 5, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            ((CustomerEmployee)this.data).setDateFrom(this.panelPeriod.getLocalDateFrom());
            ((CustomerEmployee)this.data).setDateTo(this.panelPeriod.getLocalDateTo());
            ((CustomerEmployee)this.data).setPosition(this.position.getText());
            ((CustomerEmployee)this.data).setFio(this.fio.getText());
            ((CustomerEmployee)this.data).setPhone(this.phone.getText());
            ((CustomerEmployee)this.data).setMobile(this.mobile.getText());
            ((CustomerEmployee)this.data).setEmail(this.email.getText());
            ((CustomerEmployee)this.data).setBirthday(this.birthday.getLocalDate());
            ((CustomerEmployee)this.data).setAddress(this.address.getText());
            ((CustomerEmployee)this.data).setDocumentSerial(this.documentSerial.getText());
            ((CustomerEmployee)this.data).setDocumentNumber(this.documentNumber.getText());
            ((CustomerEmployee)this.data).setDocumentWhoGive(this.documentWhoGive.getText());
            ((CustomerEmployee)this.data).setDocumentWhenGive(this.documentWhenGive.getLocalDate());
            ((CustomerEmployee)this.data).setComment(this.comment.getText());
            return true;
        }

        @Override
        public void doCancel() {
            this.data = null;
        }
    }
}

