/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentInfo;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentInfoDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.integration.common.bean.Register;
import ru.bitel.bgbilling.kernel.integration.common.bean.RegisterItem;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterItemManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class RegisterManager {
    private Connection con;

    public RegisterManager(Connection con) {
        this.con = con;
    }

    public Register getRegisterById(int id) throws BGException {
        Register result = null;
        String query = "SELECT * FROM payment_register WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.loadRegisterFromRS(rs);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void updateRegister(Register register) throws BGException {
        boolean update = register.getId() > 0;
        String query = (update ? "UPDATE" : "INSERT INTO") + " payment_register SET date=?, title=?, load_time=?, count=?, errorCount=?, summa=?, processed=?, process_time=?, load_log=?, ptitle=?, regtype=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate(register.getDate()));
            ps.setString(2, register.getTitle());
            ps.setTimestamp(3, TimeUtils.convertCalendarToTimestamp(register.getLoadTime()));
            ps.setInt(4, register.getStringsCount());
            ps.setInt(5, register.getErrorCount());
            ps.setBigDecimal(6, register.getSumm());
            ps.setInt(7, register.isProcessed() ? 1 : 0);
            ps.setTimestamp(8, TimeUtils.convertCalendarToTimestamp(register.getProcessTime()));
            ps.setString(9, register.getLoadLog());
            ps.setString(10, register.getPatternTitle());
            ps.setInt(11, register.getRegisterType());
            if (update) {
                ps.setInt(12, register.getId());
            }
            ps.executeUpdate();
            if (!update) {
                register.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public void deleteRegister(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM payment_register WHERE id=?");){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public List<Register> getRegisterList(Period period, int limit) throws BGException {
        return this.getRegisterList(period, limit, 0);
    }

    public List<Register> getRegisterList(Period period, int limit, int regType) throws BGException {
        ArrayList<Register> result = new ArrayList<Register>();
        String query = "SELECT * FROM payment_register WHERE ( ISNULL(?) OR ?<=date ) AND ( ISNULL(?) OR ?>=date ) AND regtype=? ORDER BY date DESC LIMIT ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate(period.getDateFrom()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate(period.getDateFrom()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(period.getDateTo()));
            ps.setDate(4, TimeUtils.convertDateToSqlDate(period.getDateTo()));
            ps.setInt(5, regType);
            ps.setInt(6, limit);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.loadRegisterFromRS(rs));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    private Register loadRegisterFromRS(ResultSet rs) throws SQLException {
        Register result = new Register();
        result.setId(rs.getInt("id"));
        result.setDate(rs.getDate("date"));
        result.setRegisterType(rs.getInt("regtype"));
        result.setLoadTime(TimeUtils.convertTimestampToCalendar(rs.getTimestamp("load_time")));
        result.setStringsCount(rs.getInt("count"));
        result.setErrorCount(rs.getInt("errorCount"));
        result.setSumm(rs.getBigDecimal("summa"));
        result.setTitle(rs.getString("title"));
        result.setProcessed(rs.getInt("processed") > 0);
        result.setProcessTime(TimeUtils.convertTimestampToCalendar(rs.getTimestamp("process_time")));
        result.setLoadLog(rs.getString("load_log"));
        result.setPatternTitle(rs.getString("ptitle"));
        return result;
    }

    public void processRegister(int userId, Register register) throws BGException {
        block33: {
            RegisterItemManager registerItemManager = new RegisterItemManager(this.con);
            if (register.getRegisterType() == 1) {
                try (ChargeDao chargeDao = new ChargeDao(this.con);
                     BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                    for (RegisterItem item : registerItemManager.getRegisterItems(register)) {
                        if (item.getSumma().compareTo(BigDecimal.ZERO) == 0) continue;
                        Charge charge = new Charge();
                        charge.setDate(item.getDate());
                        charge.setContractId(item.getContractId());
                        charge.setComment(item.getBalanceItemComment());
                        charge.setTypeId(item.getBalanceItemTypeId());
                        charge.setSum(item.getSumma());
                        charge.setUserId(userId);
                        chargeDao.update(charge);
                        balanceUtils.updateBalance(charge.getDate(), charge.getContractId());
                        this.con.commit();
                        EventProcessor.getInstance().publish(new ChargeEvent(userId, charge));
                        EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(charge.getContractId(), 4, charge.getSum()));
                        item.setBalanceItemId(charge.getId());
                        registerItemManager.updateRegisterItem(register, item);
                    }
                    break block33;
                }
                catch (Exception ex) {
                    throw new BGException(ex);
                }
            }
            try (PaymentDao paymentDao = new PaymentDao(this.con);
                 BalanceUtils balanceUtils = new BalanceUtils(this.con);
                 PaymentInfoDao paymentInfoDao = new PaymentInfoDao(this.con);){
                for (RegisterItem item : registerItemManager.getRegisterItems(register)) {
                    if (item.getSumma().compareTo(BigDecimal.ZERO) == 0) continue;
                    Payment payment = Payment.builder().setDate(item.getDate()).setContractId(item.getContractId()).setComment(item.getBalanceItemComment()).setTypeId(item.getBalanceItemTypeId()).setSum(item.getSumma()).setUserId(userId).build();
                    paymentDao.update(payment);
                    balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                    Map<String, String> paymentInfo = item.getExtraParametersMap();
                    if (paymentInfo != null && paymentInfo.size() > 0) {
                        PaymentInfo info = new PaymentInfo(payment.getId());
                        info.setInfo(paymentInfo);
                        paymentInfoDao.update(info);
                    }
                    this.con.commit();
                    EventProcessor.getInstance().publish(new PaymentEvent(userId, payment));
                    EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(payment.getContractId(), 3, payment.getSum()));
                    item.setBalanceItemId(payment.getId());
                    registerItemManager.updateRegisterItem(register, item);
                }
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
        register.setProcessed(true);
        this.updateRegister(register);
    }
}

