/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.netflow.nat;

import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.NatLogExportParameters;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.NatLogHsl;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.NatLogHslSort;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.kernel.network.flow.Netflow9Processor;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.worker.Recyclable;

abstract class CiscoHslNatLogProcessor
implements Netflow9Processor,
Recyclable,
Flushable {
    private static final Logger logger = LogManager.getLogger();
    private static final Comparator<NatLogHsl> COMPARATOR = new Comparator<NatLogHsl>(){

        @Override
        public int compare(NatLogHsl o1, NatLogHsl o2) {
            return o1.millis < o2.millis ? -1 : (o1.millis == o2.millis ? 0 : 1);
        }
    };
    private final NatLogHslSort sortedLog = new NatLogHslSort(COMPARATOR, 500000);
    private final byte[] extAddress;
    private final int[] extPorts;

    public CiscoHslNatLogProcessor(byte[] extAddress, Set<Integer> extPorts) {
        this.extAddress = extAddress;
        if (extPorts == null || extPorts.size() == 0) {
            this.extPorts = null;
        } else {
            this.extPorts = new int[extPorts.size()];
            int pos = 0;
            for (Integer port : extPorts) {
                this.extPorts[pos++] = port;
            }
        }
    }

    @Override
    public void process(ByteBuffer readBuffer, int offset, long millis, NetFlow9Template template) throws Exception {
        boolean add;
        if (!template.hslNatLog) {
            return;
        }
        long millis2 = millis;
        byte[] srcAddress = null;
        byte[] t_srcAddress = null;
        byte[] dstAddress = null;
        byte[] t_dstAddress = null;
        int srcPort = 0;
        int t_srcPort = 0;
        int dstPort = 0;
        int t_dstPort = 0;
        int vrfId = 0;
        byte protocol = 0;
        int pos = offset + template.hslNatLogFieldEvent.offset;
        if (pos >= readBuffer.limit()) {
            return;
        }
        byte event = readBuffer.get(pos);
        if (event == 0) {
            return;
        }
        boolean bl = add = event == 1;
        if (template.hslNatLogFieldTranslatedSourceIpv4Addr.init) {
            readBuffer.position(offset + template.hslNatLogFieldTranslatedSourceIpv4Addr.offset);
            t_srcAddress = new byte[template.hslNatLogFieldTranslatedSourceIpv4Addr.length];
            readBuffer.get(t_srcAddress);
        }
        if (this.extAddress != null && !IpAddress.equals(this.extAddress, t_srcAddress)) {
            return;
        }
        if (template.hslNatLogFieldTranslatedSourcePort.init) {
            t_srcPort = readBuffer.getShort(offset + template.hslNatLogFieldTranslatedSourcePort.offset) & 0xFFFF;
        }
        if (this.extPorts != null) {
            boolean find = false;
            int size = this.extPorts.length;
            for (int i = 0; i < size; ++i) {
                if (this.extPorts[i] != t_srcPort) continue;
                find = true;
                break;
            }
            if (!find) {
                return;
            }
        }
        if (template.ip4SrcAddressItem.init) {
            readBuffer.position(offset + template.ip4SrcAddressItem.offset);
            srcAddress = new byte[template.ip4SrcAddressItem.length];
            readBuffer.get(srcAddress);
        }
        if (template.l4SrcPortItem.init) {
            srcPort = readBuffer.getShort(offset + template.l4SrcPortItem.offset) & 0xFFFF;
        }
        if (template.hslNatLogFieldTimestamp.init) {
            millis = readBuffer.getLong(offset + template.hslNatLogFieldTimestamp.offset);
        }
        if (template.hslNatLogFieldVrfId.init) {
            vrfId = readBuffer.getInt(offset + template.hslNatLogFieldVrfId.offset);
        }
        if (template.protocolItem.init) {
            protocol = readBuffer.get(offset + template.protocolItem.offset);
        }
        dstAddress = new byte[template.ip4DstAddressItem.length];
        if (template.ip4DstAddressItem.init) {
            readBuffer.position(offset + template.ip4DstAddressItem.offset);
            readBuffer.get(dstAddress);
        }
        if (template.l4DstPortItem.init) {
            dstPort = readBuffer.getShort(offset + template.l4DstPortItem.offset) & 0xFFFF;
        }
        t_dstAddress = new byte[template.hslNatLogFieldTranslatedDestinationIPv4Addr.length];
        if (template.hslNatLogFieldTranslatedDestinationIPv4Addr.init) {
            readBuffer.position(offset + template.hslNatLogFieldTranslatedDestinationIPv4Addr.offset);
            readBuffer.get(t_dstAddress);
        }
        if (template.hslNatLogFieldTranslatedDestinationPort.init) {
            t_dstPort = readBuffer.getShort(offset + template.hslNatLogFieldTranslatedDestinationPort.offset) & 0xFFFF;
        }
        if (srcAddress != null && t_srcAddress != null) {
            NatLogHsl natLogHSL = new NatLogHsl(srcAddress, srcPort, t_srcAddress, t_srcPort, dstAddress, dstPort, t_dstAddress, t_dstPort, vrfId, protocol, millis, millis2, add);
            this.sortedLog.add(natLogHSL);
        } else if (logger.isTraceEnabled()) {
            logger.trace("Unknown HSL record with empty ext or int address (template " + template.templateId + ")");
        }
    }

    @Override
    public void recycle() {
        this.sortedLog.recycle();
    }

    @Override
    public void flush() throws IOException {
        HashMap<NatLogHsl, NatLogHsl> addsMap = new HashMap<NatLogHsl, NatLogHsl>();
        HashMap<NatLogHsl, NatLogHsl> deletesMap = new HashMap<NatLogHsl, NatLogHsl>();
        for (NatLogHsl natLogHSL : this.sortedLog) {
            if (natLogHSL.add) {
                NatLogHsl deletes = (NatLogHsl)deletesMap.remove(natLogHSL);
                if (deletes == null) {
                    addsMap.put(natLogHSL, natLogHSL);
                    continue;
                }
                this.process(natLogHSL, natLogHSL.millis, deletes.millis, natLogHSL.millis2, deletes.millis2);
                continue;
            }
            NatLogHsl adds = (NatLogHsl)addsMap.remove(natLogHSL);
            if (adds == null) {
                deletesMap.put(natLogHSL, natLogHSL);
                continue;
            }
            this.process(adds, adds.millis, natLogHSL.millis, adds.millis2, natLogHSL.millis2);
        }
        this.sortedLog.clear();
        for (NatLogHsl natLogHSL : deletesMap.values()) {
            this.process(natLogHSL, 0L, natLogHSL.millis, 0L, natLogHSL.millis2);
        }
        deletesMap.clear();
        for (NatLogHsl natLogHSL : addsMap.values()) {
            this.process(natLogHSL, natLogHSL.millis, 0L, natLogHSL.millis2, 0L);
        }
        addsMap.clear();
    }

    protected abstract void process(NatLogHsl var1, long var2, long var4, long var6, long var8) throws IOException;

    public static class ExportCiscoNatLogProcessor
    extends CiscoHslNatLogProcessor {
        final long timeFromMillis;
        final long timeToMillis;
        final Date utilDate = new Date();
        final Writer writer;
        final DateFormat format;

        public ExportCiscoNatLogProcessor(NatLogExportParameters exportParameters, Writer writer, DateFormat format) throws IOException {
            super(exportParameters.address, exportParameters.ports);
            this.timeFromMillis = exportParameters.timeFromMillis;
            this.timeToMillis = exportParameters.timeToMillis;
            this.writer = writer;
            this.format = format;
            writer.write("Source IP\t");
            writer.write("Translated source IP\t");
            writer.write("Destination IP\t");
            writer.write("Translated destination IP\t");
            writer.write("Original source port\t");
            writer.write("Translated source port\t");
            writer.write("Original destination port\t");
            writer.write("Translated destination port\t");
            writer.write("Virtual routing and forwarding (VFR) ID\t");
            writer.write("Protocol\t");
            writer.write("Event\t");
            writer.write("Unix timestamp (assign)\t");
            writer.write("Unix timestamp (unassign)\n");
        }

        @Override
        protected void process(NatLogHsl natLogHSL, long millisFrom, long millisTo, long millis2From, long millis2To) throws IOException {
            if (this.timeFromMillis != 0L && this.timeFromMillis > millisTo || this.timeToMillis != 0L && this.timeToMillis < millisFrom) {
                return;
            }
            this.processFilter(millisFrom, millisTo, natLogHSL.srcAddress, natLogHSL.t_srcAddress, natLogHSL.dstAddress, natLogHSL.t_dstAddress, natLogHSL.srcPort, natLogHSL.t_srcPort, natLogHSL.dstPort, natLogHSL.t_dstPort, natLogHSL.vrfId, natLogHSL.protocol, natLogHSL.add);
        }

        protected void processFilter(long assingMillis, long unassignMillis, byte[] srcAddress, byte[] t_srcAddress, byte[] dstAddress, byte[] t_dstAddress, int srcPort, int t_srcPort, int dstPort, int t_dstPort, int vrfId, byte protocol, boolean event) throws IOException {
            this.writer.write(IpAddress.toString(srcAddress));
            this.writer.write(9);
            this.writer.write(IpAddress.toString(t_srcAddress));
            this.writer.write(9);
            this.writer.write(IpAddress.toString(dstAddress));
            this.writer.write(9);
            this.writer.write(IpAddress.toString(t_dstAddress));
            this.writer.write(9);
            this.writer.write(String.valueOf(srcPort));
            this.writer.write(9);
            this.writer.write(String.valueOf(t_srcPort));
            this.writer.write(9);
            this.writer.write(String.valueOf(dstPort));
            this.writer.write(9);
            this.writer.write(String.valueOf(t_dstPort));
            this.writer.write(9);
            this.writer.write(String.valueOf((long)vrfId & 0xFFFFFFFFL));
            this.writer.write(9);
            this.writer.write(String.valueOf(protocol));
            this.writer.write(9);
            this.writer.write(event ? "1" : "2");
            this.writer.write(9);
            if (this.format != null) {
                if (assingMillis != 0L) {
                    this.utilDate.setTime(assingMillis);
                    this.writer.write(this.format.format(this.utilDate));
                }
                this.writer.write(9);
                if (unassignMillis != 0L) {
                    this.utilDate.setTime(unassignMillis);
                    this.writer.write(this.format.format(this.utilDate));
                }
            } else {
                this.writer.write(String.valueOf(assingMillis));
                this.writer.write(9);
                this.writer.write(String.valueOf(unassignMillis));
            }
            this.writer.write(10);
        }
    }
}

