/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.info;

import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;

public class ShortInfo
extends RadiusAttributeInfo<Short> {
    public ShortInfo(int vendor, int code, String name, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 5, attr, children);
    }

    protected ShortInfo(int vendor, int code, String name, int valueType, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, valueType, attr, children);
    }

    @Override
    public Short unwrapValue(ByteBuffer data) {
        if (this.tag == 1) {
            return (short)((data.get(0) & 0xFF) << 0);
        }
        return data.getShort(0);
    }

    @Override
    public ByteBuffer wrapValue(Short value) {
        if (this.tag == 1) {
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.put(0, (byte)(value & 0xFF));
            return bb;
        }
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.putShort(value);
        bb.rewind();
        return bb;
    }
}

