/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.jmx;

import java.lang.management.ManagementFactory;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.Utils;

public class MBeanUtils {
    private static final Logger logger = LogManager.getLogger();

    public static String mbeanInvoke(String objectName, String operationName) throws Exception {
        logger.info("mbeanInvoke " + objectName + " " + operationName);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName(objectName);
        return String.valueOf(mBeanServer.invoke(name, operationName, new Object[0], new String[0]));
    }

    public static String mbeanGet(String objectName, String attribute) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            return String.valueOf(mbs.getAttribute(new ObjectName(objectName), attribute));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String mbeanSet(String objectName, String attribute, String value) throws Exception {
        logger.info("mbeanSet " + objectName + " " + attribute + " to " + value);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            String type = "";
            for (MBeanAttributeInfo i : mbs.getMBeanInfo(new ObjectName(objectName)).getAttributes()) {
                if (!attribute.equals(i.getName())) continue;
                type = i.getType();
                break;
            }
            Object v = value;
            if (type.contains("java.lang.Double") || type.contains("double")) {
                v = Utils.parseDouble(value, 0.0);
            } else if (type.contains("java.lang.Float") || type.contains("float")) {
                v = Float.valueOf(Utils.parseFloat(value, 0.0f));
            } else if (type.contains("java.lang.Boolean") || type.contains("boolean")) {
                v = Utils.parseBoolean(value, false);
            } else if (type.contains("java.lang.Integer") || type.contains("int")) {
                v = Utils.parseInt(value);
            } else if (type.contains("java.lang.Long") || type.contains("long")) {
                v = Utils.parseLong(value);
            }
            logger.info("Setting " + objectName + " " + attribute + " to " + v + " (" + v.getClass().getName() + ")");
            mbs.setAttribute(new ObjectName(objectName), new Attribute(attribute, v));
            return MBeanUtils.mbeanGet(objectName, attribute);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String mbeanInfo(String objectNameString) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName(objectNameString);
        StringBuilder sb = new StringBuilder();
        MBeanUtils.mbeanInfo(mBeanServer, objectName, sb);
        return sb.toString();
    }

    private static void mbeanInfo(MBeanServer mBeanServer, ObjectName objectName, StringBuilder sb) throws Exception {
        MBeanInfo info = mBeanServer.getMBeanInfo(objectName);
        sb.append("MBean ").append(objectName).append('\n');
        sb.append("Attributes:\n");
        for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
            sb.append("  ").append(mBeanAttributeInfo.getName()).append("\t\t").append(mBeanAttributeInfo.getType()).append('\t');
            if (mBeanAttributeInfo.isReadable()) {
                try {
                    sb.append(mBeanServer.getAttribute(objectName, mBeanAttributeInfo.getName())).append('\t');
                }
                catch (Exception ex) {
                    sb.append("notSupported").append('\t');
                }
            } else {
                sb.append("notReadable").append('\t');
            }
            if (mBeanAttributeInfo.isWritable()) {
                sb.append("writable, ");
            } else {
                sb.append("notWritable, ");
            }
            sb.append(mBeanAttributeInfo.getDescription()).append('\n');
        }
        sb.append("Operations:\n");
        for (MBeanFeatureInfo mBeanFeatureInfo : info.getOperations()) {
            sb.append("  ").append(mBeanFeatureInfo.getName()).append("\t\t").append(((MBeanOperationInfo)mBeanFeatureInfo).getReturnType()).append('\t').append(mBeanFeatureInfo.getDescription()).append('\n');
        }
        sb.setLength(sb.length() - 1);
    }

    public static String mbeanQuery(String objectNameString) throws Exception {
        StringBuilder sb = new StringBuilder();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = null;
        objectName = Utils.notBlankString(objectNameString) ? new ObjectName(objectNameString) : new ObjectName("ru.*:*");
        for (ObjectName name : mBeanServer.queryNames(objectName, null)) {
            MBeanUtils.mbeanInfo(mBeanServer, name, sb);
            sb.append("\n\n");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void unregisterMBean(ObjectName objectName, Logger logger) {
        if (objectName != null) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(MBeanUtils.mbeanQuery("*:*"));
    }
}

