/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Result;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class IPResourceSubcriptionPanel
extends BGUPanel {
    private IpResourceSubscriptionTableModel model = new IpResourceSubscriptionTableModel();
    private BGControlPanelPeriod period = new BGControlPanelPeriod();
    private BGControlPanelPages pages = new BGControlPanelPages();
    private IpResource current = null;

    public IPResourceSubcriptionPanel() {
        super(new BorderLayout(0, 3));
    }

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        BGSwingUtilites.handleRefresh(this, this.period, this.pages);
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)new JScrollPane(table), "Center");
    }

    private JPanel getTopPanel() {
        JButton backButton = new JButton("<-- \u043d\u0430\u0437\u0430\u0434 \u043a \u0441\u043f\u0438\u0441\u043a\u0443");
        backButton.addActionListener(e -> ((BGEditor)this.getParent()).performAction("close"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)backButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.period, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder(this.pages, " \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u044b "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.MenuAction("ipResource.subscription", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                IPResourceSubcriptionPanel.this.current = (IpResource)e.getSource();
                if (IPResourceSubcriptionPanel.this.current != null) {
                    BGSwingUtilites.wrapBorder(IPResourceSubcriptionPanel.this, " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430 " + IPResourceSubcriptionPanel.this.current.getId() + "  ");
                    IPResourceSubcriptionPanel.this.performAction("refresh");
                    IPResourceSubcriptionPanel.this.performActionOpen();
                }
            }
        };
        new AbstractBGUPanel.AsyncAction<Result<IpResourceSubscription>>("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            protected Result<IpResourceSubscription> doInBackground() throws Exception {
                return ((ClientContext)IPResourceSubcriptionPanel.this.getContext()).getPort(ResourceService.class).ipSubscriptionList(IPResourceSubcriptionPanel.this.current.getId(), IPResourceSubcriptionPanel.this.period.getDateFrom(), IPResourceSubcriptionPanel.this.period.getDateTo(), IPResourceSubcriptionPanel.this.pages.getPage());
            }

            @Override
            protected void done(Result<IpResourceSubscription> result) throws Exception {
                IPResourceSubcriptionPanel.this.model.setData(result.getList());
                IPResourceSubcriptionPanel.this.pages.setPage(result.getPage());
            }
        };
    }

    class IpResourceSubscriptionTableModel
    extends BGTableModel<IpResourceSubscription> {
        public IpResourceSubscriptionTableModel() {
            super(IpResourceSubscriptionTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d", 200, 300, 400, null, false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, null, false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a", -1, 120, -1, "subscriberTitle", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(IpResourceSubscription val, int column) throws BGException {
            switch (column) {
                case 1: {
                    return IpAddress.toString(val.getAddressFrom()) + " - " + IpAddress.toString(val.getAddressTo());
                }
                case 2: {
                    return TimeUtils.formatPeriod(val.getDateFrom(), val.getDateTo());
                }
            }
            return super.getValue(val, column);
        }
    }
}

