/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.server.call.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.call.server.event.NasListModifiedEvent;
import ru.bitel.common.TimeUtils;

public class ActionUpdateNasInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", 0);
        int mid = this.getIntParameter("mid", -1);
        String title = this.getParameter("title");
        String secret = this.getParameter("secret");
        long addr = IPUtils.convertStringIPtoLong((String)this.getParameter("addr", ""), (long)0L);
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        String comment = this.getParameter("comment");
        int config = this.getIntParameter("config", -1);
        String common_config = this.getParameter("common_config", "");
        String script = this.getParameter("script", "");
        if (id < 0 || title == null || secret == null || addr <= 0L || mid < 0 || comment == null) {
            throw new BGIllegalArgumentException();
        }
        int vendor = this.getIntParameter("vendor", 0);
        if (id == 0) {
            query = "INSERT INTO nas_" + mid + " ( identifier, secret, ipaddr,  date1, date2, comment, config_id, common_config_id, vendor, script  ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, title);
            ps.setString(2, secret);
            ps.setLong(3, addr);
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)date2));
            ps.setString(6, comment);
            ps.setInt(7, config);
            ps.setString(8, common_config);
            ps.setInt(9, vendor);
            ps.setString(10, script);
            ps.executeUpdate();
            ps.close();
        } else {
            query = "UPDATE nas_" + mid + " SET identifier=?, secret=?, ipaddr=?, date1=?, date2=?, comment=?, config_id=?, common_config_id=?, vendor=?, script=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, title);
            ps.setString(2, secret);
            ps.setLong(3, addr);
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)date2));
            ps.setString(6, comment);
            ps.setInt(7, config);
            ps.setString(8, common_config);
            ps.setInt(9, vendor);
            ps.setString(10, script);
            ps.setInt(11, id);
            ps.executeUpdate();
            ps.close();
        }
        try {
            EventProcessor.getInstance().publish(new NasListModifiedEvent(mid, this.userId));
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

