/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UnregRequestRecord;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class UserRecordLogDao
extends AbstractDao<UnregRequestRecord> {
    private static final String TABLE_UNREGISTRATION = "bgs_request_unregistration";

    public UserRecordLogDao(Connection con) {
        super(con, 0, TABLE_UNREGISTRATION);
    }

    public void searchUnregRequestRecordList(SearchResult<UnregRequestRecord> searchResult) throws BGException {
        Objects.requireNonNull(searchResult);
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM bgs_request_unregistration ORDER BY last_time DESC" + (page != null ? page.sqlLimit() : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected UnregRequestRecord getFromRS(ResultSet rs) throws SQLException, BGException {
        return (UnregRequestRecord)this.ormFromResultSet(rs, UnregRequestRecord.class);
    }

    protected void updateImpl(UnregRequestRecord record) throws BGException, SQLException {
        int index;
        PreparedStatement ps;
        Objects.requireNonNull(record);
        boolean update = false;
        String querySet = " SET module_id=?, action=?, service=?, operation=?, contract_id=?, user_id=?, last_time=?";
        String query = "UPDATE bgs_request_unregistration" + querySet + " WHERE true" + (record.getAction() != null ? " AND action=?" : "") + (record.getService() != null ? " AND service=?" : "") + (record.getOperation() != null ? " AND operation=?" : "");
        try {
            ps = this.con.prepareStatement(query);
            try {
                index = 1;
                ps.setString(index++, record.getModuleId());
                ps.setString(index++, record.getAction());
                ps.setString(index++, record.getService());
                ps.setString(index++, record.getOperation());
                ps.setInt(index++, record.getContractId());
                ps.setInt(index++, record.getUserId());
                ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)record.getLastTime()));
                if (record.getAction() != null) {
                    ps.setString(index++, record.getAction());
                }
                if (record.getService() != null) {
                    ps.setString(index++, record.getService());
                }
                if (record.getOperation() != null) {
                    ps.setString(index++, record.getOperation());
                }
                update = ps.executeUpdate() > 0;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        if (!update) {
            query = "INSERT INTO bgs_request_unregistration" + querySet;
            try {
                ps = this.con.prepareStatement(query);
                try {
                    index = 1;
                    ps.setString(index++, record.getModuleId());
                    ps.setString(index++, record.getAction());
                    ps.setString(index++, record.getService());
                    ps.setString(index++, record.getOperation());
                    ps.setInt(index++, record.getContractId());
                    ps.setInt(index++, record.getUserId());
                    ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)record.getLastTime()));
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void clearUnregRequestRecordList() throws BGException {
        String query = "DELETE FROM bgs_request_unregistration";
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteUnregRequestRecord(UnregRequestRecord record) throws BGException {
        String query = "DELETE FROM bgs_request_unregistration WHERE true" + (record.getAction() != null ? " AND action=?" : "") + (record.getModuleName() != null ? " AND moduleName=?" : "") + (record.getService() != null ? " AND service=?" : "") + (record.getOperation() != null ? " AND operation=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            if (record.getAction() != null) {
                ps.setString(index++, record.getAction());
            }
            if (record.getModuleName() != null) {
                ps.setString(index++, record.getModuleName());
            }
            if (record.getService() != null) {
                ps.setString(index++, record.getService());
            }
            if (record.getOperation() != null) {
                ps.setString(index++, record.getOperation());
            }
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void clearUnregRequestActionRecord(List<String> recordIds) throws BGException {
        String query = "DELETE FROM bgs_request_unregistration WHERE module_id=? AND action=?";
        this.clearUnregRequestServiceRecord(query, recordIds);
    }

    public void clearUnregRequestServiceRecord(List<String> recordIds) throws BGException {
        String query = "DELETE FROM bgs_request_unregistration WHERE service=? AND operation=?";
        this.clearUnregRequestServiceRecord(query, recordIds);
    }

    private void clearUnregRequestServiceRecord(String query, List<String> recordIds) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (String recordId : recordIds) {
                String[] data = recordId.split("_");
                int index = 1;
                ps.setString(index++, data[1]);
                ps.setString(index++, data[2]);
                ps.executeUpdate();
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

