/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;

public class ContractSubPanel_Modules
extends ContractSubPanel {
    private final BGControlPanelListSelect selectedList = new BGControlPanelListSelect();
    private final BGControlPanelListSelect availableList = new BGControlPanelListSelect();

    public ContractSubPanel_Modules() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        BGButton addButton = new BGButton("<");
        addButton.setColumns(5);
        addButton.addActionListener(e -> this.newItem());
        BGButton delButton = new BGButton(">", "delModule");
        delButton.addActionListener(e -> this.deleteItem());
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add(Box.createVerticalStrut(50), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)addButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        controlPanel.add((Component)delButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        controlPanel.add(Box.createGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.wrapListToPanel(this.selectedList, "\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438"), new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(controlPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.wrapListToPanel(this.availableList, "\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438"), new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel wrapListToPanel(BGControlPanelListSelect list, String title) {
        Dimension dimension = new Dimension(200, 200);
        JPanel selectedListPanel = new JPanel(new GridBagLayout());
        selectedListPanel.setMinimumSize(dimension);
        selectedListPanel.setPreferredSize(dimension);
        selectedListPanel.setBorder((Border)new BGTitleBorder(title));
        selectedListPanel.add((Component)list, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return selectedListPanel;
    }

    public void setData() {
        try {
            ModuleService moduleService = (ModuleService)this.getContext().getPort(ModuleService.class, 0);
            ClientUtils.buildList((JList)this.availableList.getList(), moduleService.moduleList());
            ClientUtils.buildList((JList)this.selectedList.getList(), moduleService.contractModules(this.getContractId()));
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void newItem() {
        String selectIds = this.availableList.getListValues();
        if (Utils.notBlankString((String)selectIds)) {
            try {
                ((ContractService)this.getContext().getWebService(ContractService.class, 0)).contractModuleAdd(this.getContractId(), Utils.toIntegerList((String)selectIds));
                this.setData();
                EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void deleteItem() {
        String selectIds = this.selectedList.getListValues();
        if (selectIds.length() > 0 && ClientUtils.confirm((String)"\u0412\u0441\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043c\u043e\u0434\u0443\u043b\u0435\u0439, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u0430\u044f \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u0431\u0443\u0434\u0435\u0442 \u0443\u0442\u0435\u0440\u044f\u043d\u0430!\n\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438?", (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u0435\u0439")) {
            try {
                ((ContractService)this.getContext().getWebService(ContractService.class, 0)).contractModuleDelete(this.getContractId(), Utils.toIntegerList((String)selectIds));
                this.setData();
                EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }
}

