/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import java.sql.SQLException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class LoaderLinkContractToTariff
extends LoaderBase {
    @Override
    public String execute(String data, String config) throws BGException {
        JSONObject configJson = new JSONObject(config);
        boolean deleteContractTariff = configJson.optBoolean("deleteContractTariff");
        HashMap<String, Integer> tariffMaps = new HashMap<String, Integer>();
        JSONArray array = configJson.optJSONArray("tariffMap");
        if (array != null) {
            for (int index = 0; index < array.length(); ++index) {
                JSONObject mapJson = array.getJSONObject(index);
                tariffMaps.put(mapJson.optString("from"), mapJson.optInt("to"));
            }
        }
        StringBuffer error = new StringBuffer();
        try (ContractDao contractDao = new ContractDao(this.con, 0);
             TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);
             ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);){
            List<IdTitle> tariffTitles = tariffPlanDao.list().stream().map(IdTitle::toIdTitle).toList();
            if (data != null) {
                int count = 0;
                for (String line : data.split("\n")) {
                    int tariffId;
                    ++count;
                    String[] parts = line.split("\t");
                    if (parts.length != 3) continue;
                    Contract contract = contractDao.getByTitle(parts[0]);
                    if (deleteContractTariff && contract != null) {
                        contractTariffDao.deleteContractTariffs(contract.getId());
                    }
                    if ((tariffId = ((Integer)tariffMaps.get(parts[1])).intValue()) == 0) {
                        tariffId = tariffTitles.stream().filter(a -> a.getTitle().equals(parts[1])).findFirst().map(Id::getId).orElse(0);
                    }
                    LocalDate dateFrom = TimeUtils.parseLocalDate((String)parts[2], (String)"yyyy-MM-dd");
                    if (contract != null && tariffId > 0 && dateFrom != null) {
                        ContractTariff contractTariff = ContractTariff.builder().setContractId(contract.getId()).setTariffPlanId(tariffId).setComment("").setPeriod(new Period(dateFrom, null)).build();
                        contractTariffDao.update(contractTariff);
                        continue;
                    }
                    error.append(String.format("ERROR in LINE: {} [contractId={}, tariffId={}, fromDate={}]\n", line, contract != null ? contract.getId() : 0, tariffId, dateFrom));
                }
                error.append("\n\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e \u0441\u0442\u0440\u043e\u043a: ").append(count);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return error.toString();
    }
}

