/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.tariff.common;

import java.util.List;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class TariffDirectory<K extends IdTitle>
implements Directory {
    private final Class<K> directoryClass;
    private final String type;
    private String name = "";
    private ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory<K> directory;

    public TariffDirectory(Class<K> directoryClass, String type) {
        this.directoryClass = directoryClass;
        this.type = type;
    }

    @Override
    public void init(int moduleId) {
        if (Utils.isBlankString((String)this.type) || this.type.equals("kernel")) {
            moduleId = 0;
        }
        ClientContext context = new ClientContext(null, moduleId, 0, 0, "");
        try {
            this.directory = context.getDirectory(this.directoryClass, moduleId);
        }
        catch (BGException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getValue(int code) {
        try {
            IdTitle value = (IdTitle)this.directory.get(code);
            return value != null ? value.getTitle() : null;
        }
        catch (BGException e) {
            e.printStackTrace();
            return null;
        }
    }

    public K get(int id) {
        try {
            return (K)((IdTitle)this.directory.get(id));
        }
        catch (BGException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<K> list() {
        try {
            return this.directory.list();
        }
        catch (BGException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int addValue(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeValue(int code) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameValue(int code, String newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IdTitle> getItems() {
        try {
            return this.directory.list();
        }
        catch (BGException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getCode(String title) {
        try {
            IdTitle value = (IdTitle)this.directory.get(title);
            return value.getId();
        }
        catch (BGException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

