/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PoolEventList;
import ru.bitel.bgbilling.kernel.event.PoolQueueEventList;
import ru.bitel.bgbilling.kernel.event.PoolTopicEventList;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.common.util.Pool;
import ru.bitel.common.xml.JAXBUtils;

public class MessageAdapter {
    protected final Session session;
    final Class<? extends Event>[] classes;
    private volatile JAXBContext jaxbContext;
    private volatile MarshallerPool marshallers;
    private volatile UnmarshallerPool unmarshallers;
    protected final int deliveryMode;
    protected final int priority;
    protected final long timeToLive;
    private static final ConcurrentMap<Class<? extends Event>, JAXBContext> JAXBCONTEXT_MAP = new ConcurrentHashMap<Class<? extends Event>, JAXBContext>();

    private static JAXBContext getJAXBContext(Class<? extends Event> clazz) throws JAXBException {
        JAXBContext result = (JAXBContext)JAXBCONTEXT_MAP.get(clazz);
        if (result != null) {
            return result;
        }
        Class[] jaxbClasses = new Class[4];
        jaxbClasses[0] = clazz;
        jaxbClasses[jaxbClasses.length - 3] = PoolEventList.class;
        jaxbClasses[jaxbClasses.length - 2] = PoolTopicEventList.class;
        jaxbClasses[jaxbClasses.length - 1] = PoolQueueEventList.class;
        result = JAXBContext.newInstance((Class[])jaxbClasses);
        JAXBCONTEXT_MAP.put(clazz, result);
        return result;
    }

    private static JAXBContext getJAXBContext(Class<?> ... classes) throws JAXBException {
        Class[] jaxbClasses = Arrays.copyOf(classes, classes.length + 3);
        jaxbClasses[jaxbClasses.length - 3] = PoolEventList.class;
        jaxbClasses[jaxbClasses.length - 2] = PoolTopicEventList.class;
        jaxbClasses[jaxbClasses.length - 1] = PoolQueueEventList.class;
        return JAXBUtils.getContext((Class[])jaxbClasses);
    }

    public MessageAdapter(Session session, Class<? extends Event> clazz) throws JAXBException {
        this.session = session;
        this.classes = new Class[]{clazz};
        this.jaxbContext = MessageAdapter.getJAXBContext(clazz);
        this.marshallers = new MarshallerPool(this.jaxbContext);
        this.unmarshallers = new UnmarshallerPool(this.jaxbContext);
        EventType type = clazz.getAnnotation(EventType.class);
        if (type != null) {
            this.deliveryMode = type.deliveryMode();
            this.priority = type.priority();
            this.timeToLive = type.timeToLive();
        } else {
            this.deliveryMode = 2;
            this.priority = 4;
            this.timeToLive = 0L;
        }
    }

    public MessageAdapter(Session session, int deliveryMode, int priority, long timeToLive, Class<?> ... classes) throws JAXBException {
        this.session = session;
        this.classes = classes;
        this.jaxbContext = MessageAdapter.getJAXBContext(classes);
        this.marshallers = new MarshallerPool(this.jaxbContext);
        this.unmarshallers = new UnmarshallerPool(this.jaxbContext);
        this.deliveryMode = deliveryMode;
        this.priority = priority;
        this.timeToLive = timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Message createMessage(Event e) throws JAXBException, JMSException {
        MarshallerPool marshallers;
        StringWriter sw = new StringWriter(500);
        Class<?> clazz = e.getClass();
        if (clazz != this.classes[0]) {
            if (clazz.getName().equals(this.classes[0].getName())) {
                this.classes[0] = clazz;
                MessageAdapter messageAdapter = this;
                synchronized (messageAdapter) {
                    this.jaxbContext = MessageAdapter.getJAXBContext(this.classes);
                    marshallers = this.marshallers = new MarshallerPool(this.jaxbContext);
                    this.unmarshallers = new UnmarshallerPool(this.jaxbContext);
                }
            } else {
                marshallers = this.marshallers;
            }
        } else {
            marshallers = this.marshallers;
        }
        Marshaller m = (Marshaller)marshallers.take();
        m.marshal((Object)e, (Writer)sw);
        marshallers.recycle(m);
        return this.session.createTextMessage(sw.toString());
    }

    final Message createMessage2(Event e) throws JMSException {
        return this.session.createObjectMessage((Serializable)e);
    }

    final Object parseMessage(Message message) throws JMSException, JAXBException {
        if (message instanceof TextMessage) {
            String m = ((TextMessage)message).getText();
            Unmarshaller unm = (Unmarshaller)this.unmarshallers.take();
            Object result = unm.unmarshal((Reader)new StringReader(m));
            this.unmarshallers.recycle(unm);
            return result;
        }
        return ((ObjectMessage)message).getObject();
    }

    final class MarshallerPool
    extends Pool<Marshaller> {
        private final JAXBContext context;

        public MarshallerPool(JAXBContext context) {
            this.context = context;
        }

        protected Marshaller create() {
            try {
                return this.context.createMarshaller();
            }
            catch (JAXBException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    final class UnmarshallerPool
    extends Pool<Unmarshaller> {
        private final JAXBContext context;

        public UnmarshallerPool(JAXBContext context) {
            this.context = context;
        }

        protected Unmarshaller create() {
            try {
                return this.context.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

