/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree.phone;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ZoneTrafficRangeTariffTreeNode
extends DefaultTariffTreeNode {
    public static final int OUTGOING_CALL = 1;
    public static final int INCOMING_CALL = 2;
    private static Icon icon = ClientUtils.getIcon((String)"service_range");
    private Directory zonesDir;
    private JPanel editor;
    private BGComboBox<IdTitle> zoneCombo;
    private IntTextField fromTf;
    private IntTextField toTf;
    private BGComboBox<ComboBoxItem> modeCb;
    private BGComboBox<ComboBoxItem> typeCombo;
    private JLabel view;
    private int zoneId;
    private String from;
    private String to;
    private int modeId;
    private int type;
    protected boolean TYPE_COMBO = true;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.zonesDir = this.getDirManager().getDirectory("zones");
    }

    @Override
    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.editor = new JPanel();
            this.editor.add(new JLabel("\u0422\u0440\u0430\u0444\u0438\u043a "));
            this.zoneCombo = new BGComboBox();
            this.buildDirectoryCombo(this.zonesDir, (JComboBox<IdTitle>)this.zoneCombo);
            this.editor.add((Component)this.zoneCombo);
            if (this.TYPE_COMBO) {
                this.typeCombo = new BGComboBox();
                this.typeCombo.addItem((Object)new ComboBoxItem((Object)"0", ZoneTrafficRangeTariffTreeNode.getTypeTitle(0)));
                this.typeCombo.addItem((Object)new ComboBoxItem((Object)"1", ZoneTrafficRangeTariffTreeNode.getTypeTitle(1)));
                this.typeCombo.addItem((Object)new ComboBoxItem((Object)"2", ZoneTrafficRangeTariffTreeNode.getTypeTitle(2)));
                this.editor.add((Component)this.typeCombo);
            }
            this.editor.add(new JLabel(" \u043e\u0442 "));
            this.fromTf = new IntTextField();
            this.fromTf.setColumns(5);
            this.fromTf.setMinValue(0L);
            this.toTf = new IntTextField();
            this.toTf.setColumns(5);
            this.toTf.setMinValue(0L);
            this.editor.add((Component)this.fromTf);
            this.editor.add(new JLabel(" \u0434\u043e "));
            this.editor.add((Component)this.toTf);
            this.editor.add(new JLabel(" \u043c\u0438\u043d./\u043c\u0435\u0441\u044f\u0446 "));
            this.modeCb = new BGComboBox();
            this.modeCb.addItem((Object)new ComboBoxItem((Object)"0", ZoneTrafficRangeTariffTreeNode.getModeTitle(0)));
            this.modeCb.addItem((Object)new ComboBoxItem((Object)"1", ZoneTrafficRangeTariffTreeNode.getModeTitle(1)));
            this.editor.add((Component)this.modeCb);
        }
        return this.editor;
    }

    @Override
    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder(100);
        sb.append("\u0422\u0440\u0430\u0444\u0438\u043a ");
        sb.append(this.zonesDir.getValue(this.zoneId));
        if (this.TYPE_COMBO) {
            sb.append("(");
            sb.append(ZoneTrafficRangeTariffTreeNode.getTypeTitle(this.type));
            sb.append(")");
        }
        sb.append(" \u043e\u0442 ");
        sb.append(this.from);
        sb.append(" \u0434\u043e ");
        sb.append(this.to);
        sb.append(" \u043c\u0438\u043d./\u043c\u0435\u0441\u044f\u0446 ");
        sb.append(ZoneTrafficRangeTariffTreeNode.getModeTitle(this.modeId));
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.zoneId = Utils.parseInt((String)data.get("zone"));
        this.from = Utils.maskNull((String)data.get("from"));
        this.to = Utils.maskNull((String)data.get("to"));
        this.modeId = Utils.parseInt((String)data.get("mode"));
        if (this.TYPE_COMBO) {
            this.type = Utils.parseInt((String)data.get("type"));
        }
    }

    @Override
    protected void loadData() {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox<? extends IdTitle>)this.zoneCombo, this.zoneId);
        ClientUtils.setComboBoxSelection(this.modeCb, (Object)String.valueOf(this.modeId));
        if (this.TYPE_COMBO) {
            ClientUtils.setComboBoxSelection(this.typeCombo, (Object)String.valueOf(this.type));
        }
        this.fromTf.setText(this.from);
        this.toTf.setText(this.to);
    }

    @Override
    protected void serializeData() {
        this.from = this.fromTf.getText();
        this.to = this.toTf.getText();
        this.zoneId = this.getIdFromDirectoryCombo((JComboBox<? extends IdTitle>)this.zoneCombo);
        this.modeId = Utils.parseInt((String)ClientUtils.getIdFromComboBox(this.modeCb));
        if (this.TYPE_COMBO) {
            this.type = Utils.parseInt((String)ClientUtils.getIdFromComboBox(this.typeCombo));
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("from", this.from);
        data.put("to", this.to);
        data.put("zone", String.valueOf(this.zoneId));
        data.put("mode", String.valueOf(this.modeId));
        if (this.TYPE_COMBO) {
            data.put("type", String.valueOf(this.type));
        }
        this.setDataInHash(data);
    }

    @Override
    public void serializeToXML(Element el) {
        super.serializeToXML(el);
        el.setAttribute("from", this.from);
        el.setAttribute("to", this.to);
        el.setAttribute("zone", String.valueOf(this.zoneId));
        el.setAttribute("mode", String.valueOf(this.modeId));
        if (this.TYPE_COMBO) {
            el.setAttribute("type", String.valueOf(this.type));
        }
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("from", el.getAttribute("from"));
        data.put("to", el.getAttribute("to"));
        data.put("zone", el.getAttribute("zone"));
        data.put("mode", el.getAttribute("mode"));
        data.put("type", el.getAttribute("type"));
        this.setDataInHash(data);
        this.saveData();
        this.loadChildsFromXML(el);
    }

    private static final String getModeTitle(int mode) {
        String result = "\u0431\u0435\u0437\u0443\u0441\u043b\u043e\u0432\u043d\u043e";
        if (mode == 0) {
            result = "\u043f\u0440\u043e\u043f. \u043f\u0435\u0440\u0438\u043e\u0434\u0443";
        }
        return result;
    }

    private static final String getTypeTitle(int type) {
        if (type == 1) {
            return "\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439";
        }
        if (type == 2) {
            return "\u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0439";
        }
        return "\u043e\u0431\u0449\u0438\u0439";
    }
}

