/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.security.Provider;
import java.security.Security;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.server.dbcp.DatabaseConnectionPool;
import ru.bitel.bgbilling.server.dbcp.DbcpPoolableConnectionFactory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.TrashDatabaseSelector;
import ru.bitel.bgbilling.server.util.fakesql.FakeConnection;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.AnnotatedMBean;
import ru.bitel.common.worker.WorkerThreadFactory;

public class DefaultServerSetup
extends Preferences {
    private static final Logger log;
    private static final int MAX_IDLE_DEFAULT = 20;
    private static final int MAX_ACTIVE_DEFAULT = 300;
    private static final Object repMutex;
    private Set<String> behindMasterReplications = new HashSet<String>();
    private Set<String> notAvailableReplications = new HashSet<String>();
    protected DatabaseData databaseData = null;
    private DatabaseConnectionPool connectionPool;
    private ConcurrentHashMap<String, DatabaseConnectionPool> slavePools = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> slaveErrorTimes = new ConcurrentHashMap();
    private long MIN_TIME_FOR_SLAVE_USE = 10000L;
    private ConcurrentHashMap<String, DatabaseConnectionPool> trashPools = new ConcurrentHashMap();
    private TrashDatabaseSelector trashSelector;
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(3, (ThreadFactory)new WorkerThreadFactory("setup-sched", null, null));
    private final AtomicLong traceFlag = new AtomicLong(0L);
    private volatile int traceFreq = 0;
    private boolean disablePreventionSlaveOverrun = false;
    private final ConcurrentMap<Object, StackTraceElement[]> trace = new ConcurrentHashMap<Object, StackTraceElement[]>();
    private AtomicLong lastMasterErrorTime = new AtomicLong();
    private static final long MASTER_RETEST_INTERVAL = 5000L;
    public static final int RETURN_NULL = -1;
    public static final int RETURN_FAKE = 0;
    public static final int RETURN_SLAVE = 1;
    public static final int RETURN_MASTER = 2;

    @Deprecated
    public boolean isReplicationEnabled(String slaveId) {
        return this.isReplicationNotBehindMaster(slaveId);
    }

    @Deprecated
    public void setReplicationEnabled(String slaveId, boolean enable) {
        this.setReplicationNotBehindMaster(slaveId, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplicationNotBehindMaster(String slaveId, boolean isNotBehind) {
        Object object = repMutex;
        synchronized (object) {
            if (isNotBehind) {
                this.behindMasterReplications.remove(slaveId);
            } else {
                this.behindMasterReplications.add(slaveId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicationNotBehindMaster(String slaveId) {
        Object object = repMutex;
        synchronized (object) {
            return !this.behindMasterReplications.contains(slaveId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicationAvailable(String slaveId) {
        Object object = repMutex;
        synchronized (object) {
            return !this.notAvailableReplications.contains(slaveId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplicationAvailable(String slaveId, boolean available) {
        Object object = repMutex;
        synchronized (object) {
            if (available) {
                this.notAvailableReplications.remove(slaveId);
            } else {
                this.notAvailableReplications.add(slaveId);
            }
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public DefaultServerSetup(String bundleName) {
        super(bundleName);
    }

    public DefaultServerSetup() {
    }

    public boolean initConnectionPool() {
        log.info("Init DB connection pools...");
        try {
            this.traceFreq = this.getInt("db.trace", 150);
            this.disablePreventionSlaveOverrun = this.getInt("db.disable.prevention.slave.overrun", 0) > 0;
            this.connectionPool = this.initConnectionPool("db.");
            for (String slaveId : this.parseObjectsNoOrder("db.slave.").keySet()) {
                log.info("Init slave pool {}", (Object)slaveId);
                this.slavePools.put(slaveId, this.initConnectionPool("db.slave." + slaveId + "."));
            }
        }
        catch (Exception ex) {
            log.error("error init DB connection pools", (Throwable)ex);
        }
        return this.connectionPool != null;
    }

    protected void initTrashPools() {
        log.info("Init trash pools...");
        try {
            for (String trashId : this.parseObjectsNoOrder("db.trash.").keySet()) {
                log.info("Init trash pool {}", (Object)trashId);
                this.trashPools.put(trashId, this.initConnectionPool("db.trash." + trashId + "."));
            }
            this.trashSelector = new TrashDatabaseSelector(this);
        }
        catch (Exception e) {
            log.error("error init trash pools", (Throwable)e);
        }
    }

    public void initJNDI() {
        if (Boolean.valueOf(System.getProperty("setup.jndi.init", "true")).booleanValue()) {
            log.info("Init JNDI...");
            try {
                Context current = DefaultServerSetup.getEnvironment();
                current.bind("Setup", (Object)this);
                current.bind("setup", (Object)this);
            }
            catch (NamingException e) {
                log.error("error init JNDI", (Throwable)e);
            }
        }
    }

    public static Context getEnvironment() throws NamingException {
        Properties params = new Properties();
        params.put("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        params.put("java.naming.factory.url.pkgs", "org.apache.naming");
        Context ctx = new InitialContext(params);
        try {
            ctx = (Context)ctx.lookup("java:comp/env");
        }
        catch (NamingException e) {
            try {
                ctx = (Context)ctx.lookup("java:comp");
            }
            catch (NamingException e2) {
                ctx = ctx.createSubcontext("java:comp");
            }
            ctx = ctx.createSubcontext("env");
        }
        return ctx;
    }

    private DatabaseConnectionPool initConnectionPool(String prefix) throws Exception {
        Object connectionPool = null;
        String dbDriver = this.get("db.driver", null);
        String dbURL = System.getProperty(prefix + "url", this.get(prefix + "url", null));
        String dbUser = this.get(prefix + "user", null);
        String dbPswd = this.get(prefix + "pswd", null);
        int maxIdle = this.getInt(prefix + "maxIdle", 20);
        int maxActive = this.getInt(prefix + "maxActive", 300);
        if (Utils.isBlankString((String)dbURL)) {
            return null;
        }
        Class.forName(dbDriver).getConstructor(new Class[0]).newInstance(new Object[0]);
        connectionPool = this.traceFreq > 0 ? new GenericObjectPool<Connection>(null){

            public Connection borrowObject() throws Exception {
                Connection result = (Connection)super.borrowObject();
                if (DefaultServerSetup.this.needTracePool()) {
                    DefaultServerSetup.this.trace.put(result, new Throwable().getStackTrace());
                }
                return result;
            }

            public void returnObject(Connection obj) throws Exception {
                DefaultServerSetup.this.trace.remove(obj);
                super.returnObject((Object)obj);
            }
        } : new GenericObjectPool(null);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, dbUser, dbPswd);
        connectionPool.setMaxIdle(maxIdle);
        connectionPool.setMaxActive(maxActive);
        connectionPool.setTestOnBorrow(this.getBoolean(prefix + "testOnBorrow", true));
        connectionPool.setTestOnReturn(this.getBoolean(prefix + "testOnReturn", false));
        connectionPool.setTimeBetweenEvictionRunsMillis(this.getLong(prefix + "timeBetweenEvictionRunsMillis", 30000L));
        connectionPool.setMinEvictableIdleTimeMillis(this.getLong(prefix + "minEvictableIdleTimeMillis", 1800000L));
        connectionPool.setTestWhileIdle(this.getBoolean(prefix + "testWhileIdle", true));
        connectionPool.setSoftMinEvictableIdleTimeMillis(this.getLong(prefix + "softMinEvictableIdleTimeMillis", -1L));
        connectionPool.setNumTestsPerEvictionRun(this.getInt(prefix + "numTestsPerEvictionRun", 3));
        connectionPool.setLifo(this.getBoolean(prefix + "lifo", false));
        int validationTimeout = this.getInt(prefix + "validationTimeout", -1);
        boolean defaultAutocommit = this.getBoolean(prefix + "defaultAutoCommit", true);
        new DbcpPoolableConnectionFactory((org.apache.commons.dbcp.ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, "SELECT 1", validationTimeout, false, defaultAutocommit);
        DatabaseConnectionPool result = new DatabaseConnectionPool((GenericObjectPool<Connection>)connectionPool);
        String poolname = prefix.equals("db.") ? "master" : prefix.substring(3);
        try {
            Context ctx = DefaultServerSetup.getEnvironment();
            try {
                ctx = (Context)ctx.lookup("jdbc");
            }
            catch (NamingException e) {
                ctx = ctx.createSubcontext("jdbc");
            }
            log.info("Binding JDBC pool \"" + poolname + "\" to " + ctx.composeName(poolname, "java:comp/env/jdbc"));
            ctx.bind(poolname, (Object)result.getDataSource());
            AnnotatedMBean.register((Object)result, (String)poolname);
        }
        catch (Exception e) {
            log.error("error binding JDBC pool \"" + poolname + "\"", (Throwable)e);
        }
        this.checkDB(poolname);
        return result;
    }

    private void checkDB(String poolname) throws BGException {
        Connection con = null;
        try {
            con = this.getDBConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT @@sql_mode");
            String sql_mode = "";
            if (rs.next()) {
                sql_mode = rs.getString(1);
            }
            if (sql_mode.contains("STRICT_ALL_TABLES") || sql_mode.contains("STRICT_TRANS_TABLES")) {
                throw new BGException("db " + poolname + " in strict-mode, check sql_mode variable (" + sql_mode + ")");
            }
        }
        catch (BGException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException("error check DB (" + poolname + ")", (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private boolean needTracePool() {
        int traceFreq = this.traceFreq;
        if (traceFreq > 0) {
            if (traceFreq == 1) {
                return true;
            }
            if (this.traceFlag.incrementAndGet() == (long)traceFreq) {
                this.traceFlag.set(0L);
                return true;
            }
        }
        return false;
    }

    public Object initMQ() {
        try {
            return this.initMQ0("mq.", "connectionFactory", null);
        }
        catch (Exception e) {
            log.error("error init MQ", (Throwable)e);
            return null;
        }
    }

    private Object initMQ0(String prefix, String name, ConnectionFactory def) {
        Object factory;
        String mqURL = System.getProperty(prefix + "url", this.get(prefix + "url", null));
        String mqUser = this.get(prefix + "user", null);
        String mqPswd = this.get(prefix + "pswd", null);
        if (mqURL != null) {
            try {
                Constructor<?> constructor = Class.forName("org.apache.activemq.ActiveMQConnectionFactory").getConstructor(String.class, String.class, String.class);
                factory = constructor.newInstance(mqUser, mqPswd, mqURL);
            }
            catch (Exception e) {
                log.error("error init MQ0", (Throwable)e);
                factory = null;
            }
        } else {
            factory = def;
        }
        if (factory != null) {
            try {
                Context ctx = DefaultServerSetup.getEnvironment();
                try {
                    ctx = (Context)ctx.lookup("mq");
                }
                catch (NamingException e) {
                    ctx = ctx.createSubcontext("mq");
                }
                log.info("Binding javax.jms.ConnectionFactory[" + factory + "] to " + ctx.composeName(name, "java:comp/env/mq"));
                ctx.bind(name, factory);
            }
            catch (Exception ex) {
                log.error("error init MQ0", (Throwable)ex);
            }
        }
        return factory;
    }

    public final Connection getDBConnectionFromPool() {
        return this.getDBConnectionFromPool(true);
    }

    public final Connection getDBConnectionFromPool(boolean autoCommit) {
        if (this.connectionPool == null) {
            return null;
        }
        Connection con = null;
        long lastMasterErrorTime = this.lastMasterErrorTime.get();
        if (lastMasterErrorTime != 0L) {
            long now = System.currentTimeMillis();
            if (now - lastMasterErrorTime < 5000L) {
                return null;
            }
            this.lastMasterErrorTime.compareAndSet(lastMasterErrorTime, 0L);
        }
        try {
            if (this.connectionPool.isOverload()) {
                log.error("Pool [" + this.bundleName + "]: Connections limit is over!!!!!");
                String key = "db.master.connection.limit.over";
                long time = System.currentTimeMillis();
                if (AlarmSender.needAlarmSend(key, time, 30000L)) {
                    String message = "\u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u0441\u043d\u0438\u0436\u0435\u043d\u0438\u044e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043e\u0442\u043a\u043b\u0438\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u043d\u044f\u0442\u044c \u043c\u0435\u0440\u044b \u043f\u043e \u0443\u0441\u043a\u043e\u0440\u0435\u043d\u0438\u044e \u0440\u0430\u0431\u043e\u0442\u044b Master \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445.\n\n" + this.getPoolStatus() + "\n\n" + this.getPoolStackTrace();
                    AlarmErrorMessage alarm = new AlarmErrorMessage(key, "\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a Master \u0431\u0430\u0437\u0435", message);
                    alarm.setDumpStackTrace(true);
                    AlarmSender.sendAlarm(alarm, time);
                }
            }
            if ((con = this.connectionPool.getDataSource().getConnection()).getAutoCommit() != autoCommit) {
                con.setAutoCommit(autoCommit);
            }
        }
        catch (Exception ex) {
            String key = "db.master.connect.error";
            long time = System.currentTimeMillis();
            if (AlarmSender.needAlarmSend(key, time, 10000L)) {
                String message = "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0440\u043e\u0447\u043d\u043e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 Master \u0431\u0430\u0437\u043e\u0439.\n\n" + this.getPoolStatus() + "\n\n" + this.getPoolStackTrace();
                AlarmErrorMessage alarm = new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 Master \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445", message, ex);
                alarm.setDumpStackTrace(true);
                AlarmSender.sendAlarm(alarm, time);
            }
            this.lastMasterErrorTime.set(time);
            log.error("error get DB connection from pool", (Throwable)ex);
        }
        return con;
    }

    public final Connection getDBSlaveConnectionFromPool() {
        return this.getDBSlaveConnectionFromPool(null);
    }

    public final Connection getDBSlaveConnectionFromPool(Connection master) {
        Connection con = null;
        if (this.slavePools.size() > 0) {
            try {
                String key;
                DatabaseConnectionPool prefPool = null;
                String prefId = null;
                long now = System.currentTimeMillis();
                float minRatio = Float.MAX_VALUE;
                for (Map.Entry<String, DatabaseConnectionPool> me : this.slavePools.entrySet()) {
                    float ratio;
                    Long errorTime;
                    String key2 = me.getKey();
                    DatabaseConnectionPool pool = me.getValue();
                    if (!this.isReplicationEnabled(key2) || (errorTime = this.slaveErrorTimes.get(key2)) != null && now - errorTime < this.MIN_TIME_FOR_SLAVE_USE || !((ratio = pool.getLoadRatio()) < minRatio)) continue;
                    prefPool = pool;
                    prefId = key2;
                    minRatio = ratio;
                }
                try {
                    if (prefPool != null) {
                        boolean slaveOk = true;
                        if (prefPool.isOverload()) {
                            log.error("Slave Pool [" + this.bundleName + ":" + prefId + "]: Connections limit is over!!!!!");
                            key = "db.slave.connection.limit.over";
                            String message = "\u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u0441\u043d\u0438\u0436\u0435\u043d\u0438\u044e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043e\u0442\u043a\u043b\u0438\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u043d\u044f\u0442\u044c \u043c\u0435\u0440\u044b \u043f\u043e \u0443\u0441\u043a\u043e\u0440\u0435\u043d\u0438\u044e \u0440\u0430\u0431\u043e\u0442\u044b Slave \u0431\u0430\u0437 \u0434\u0430\u043d\u043d\u044b\u0445.\n\n" + this.getPoolStatus();
                            AlarmSender.sendAlarm(key, 30000L, "\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a Slave \u0431\u0430\u0437\u0430\u043c", message);
                            slaveOk = this.disablePreventionSlaveOverrun;
                            this.slaveErrorTimes.remove(prefId);
                        }
                        if (slaveOk) {
                            con = prefPool.getDataSource().getConnection();
                            con.setAutoCommit(true);
                        }
                    }
                }
                catch (Exception ex) {
                    key = "db.slave.connect.error";
                    long time = System.currentTimeMillis();
                    String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 Slave \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445: " + prefId + ". \n\u0412\u043c\u0435\u0441\u0442\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0431\u0430\u0437\u043e\u0439 \u0431\u044b\u043b\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 Master \u0431\u0430\u0437\u043e\u0439. \n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0440\u043e\u0447\u043d\u043e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 Slave \u0431\u0430\u0437\u043e\u0439 " + prefId + ".";
                    AlarmSender.sendAlarm(key, 30000L, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 Slave \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445", message, ex);
                    this.slaveErrorTimes.put(prefId, now);
                    log.error("error get DB slave connection from pool", (Throwable)ex);
                }
            }
            catch (Exception e) {
                log.error("error get DB slave connection from pool", (Throwable)e);
            }
        }
        if (con == null) {
            con = master == null ? this.getDBConnectionFromPool() : master;
        }
        return con;
    }

    public final Connection getDBTrashConnectionFromPool(String tableName, int retType) {
        Connection result = null;
        try {
            DatabaseConnectionPool trashPool;
            String trashBase = this.trashSelector.getDatabaseName(tableName);
            if (trashBase != null && (trashPool = this.trashPools.get(trashBase)) != null) {
                if (trashPool.isOverload()) {
                    result = new FakeConnection();
                    log.error("Trash Pool [" + trashBase + "]: Connections limit is over!");
                    String key = "db.trash.connection.limit.over";
                    String message = "\u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u043c\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445.\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u043d\u044f\u0442\u044c \u043c\u0435\u0440\u044b \u043f\u043e \u0443\u0441\u043a\u043e\u0440\u0435\u043d\u0438\u044e \u0440\u0430\u0431\u043e\u0442\u044b Trash \u0431\u0430\u0437 \u0434\u0430\u043d\u043d\u044b\u0445.\n\n" + this.getPoolStatus();
                    AlarmSender.sendAlarm(key, 30000L, "\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a Trash \u0431\u0430\u0437\u0430\u043c", message);
                } else {
                    result = trashPool.getDataSource().getConnection();
                    result.setAutoCommit(true);
                }
            }
            if (result == null) {
                switch (retType) {
                    case 0: {
                        result = new FakeConnection();
                        break;
                    }
                    case 2: {
                        result = this.getDBConnectionFromPool();
                        break;
                    }
                    case 1: {
                        result = this.getDBSlaveConnectionFromPool();
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            result = new FakeConnection();
            log.error("error get DB trash connection from pool", (Throwable)e);
        }
        return result;
    }

    public final Connection getDBTrashOrMasterConnectionFromPool(String tableName) {
        return this.getDBTrashConnectionFromPool(tableName, 2);
    }

    public final Connection getDBTrashOrSlaveConnectionFromPool(String tableName) {
        return this.getDBTrashConnectionFromPool(tableName, 1);
    }

    public final Connection getSlaveConnectionFromPool(String poolId) {
        Connection con = null;
        try {
            DatabaseConnectionPool pool;
            if (poolId != null && (pool = this.slavePools.get(poolId)) != null) {
                long time;
                String key;
                con = pool.getDataSource().getConnection();
                con.setAutoCommit(true);
                if (!this.isReplicationAvailable(poolId) && AlarmSender.needAlarmSend(key = "slave.enable", time = System.currentTimeMillis(), 60000L)) {
                    String message = "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 Slave \u0411\u0414 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c  '" + poolId + "' ";
                    AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0440\u0430\u0431\u043e\u0442\u0430 \u0441\u043e Slave \u0411\u0414", message), time);
                    Setup.getSetup().setReplicationAvailable(poolId, true);
                }
            }
        }
        catch (Exception e) {
            String key = "db.slave.connect.error";
            long time = System.currentTimeMillis();
            if (this.isReplicationAvailable(poolId) && AlarmSender.needAlarmSend(key, time, 30000L)) {
                String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 Slave \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445: " + poolId + ". \n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0440\u043e\u0447\u043d\u043e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 Slave \u0431\u0430\u0437\u043e\u0439 " + poolId + ".";
                AlarmErrorMessage alarm = new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 Slave \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445", message, e);
                AlarmSender.sendAlarm(alarm, time);
                this.setReplicationAvailable(poolId, false);
            }
            log.error("error get slave connection from pool", (Throwable)e);
        }
        return con;
    }

    public final Set<String> getSlaveBaseId() {
        return this.slavePools.keySet();
    }

    public final Set<String> getTrashBaseId() {
        return this.trashPools.keySet();
    }

    public final Connection getTrashConnectionFromPool(String poolId) {
        Connection con = null;
        try {
            DatabaseConnectionPool pool;
            if (poolId != null && (pool = this.trashPools.get(poolId)) != null) {
                con = pool.getDataSource().getConnection();
                con.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            log.error("error get trash connection from pool", (Throwable)e);
        }
        return con;
    }

    @Deprecated
    public final void returnConToPool(Connection con) {
        ServerUtils.closeConnection(con);
    }

    public String getPoolStatus() {
        GenericObjectPool<Connection> pool;
        String name;
        if (this.connectionPool == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("Connections pool to Master status ");
        sb.append(this.poolStatus(this.connectionPool.getPool()));
        for (Map.Entry<String, DatabaseConnectionPool> me : this.slavePools.entrySet()) {
            name = me.getKey();
            pool = me.getValue().getPool();
            sb.append("\n").append("Connections pool to Slave \"" + name + "\" status ").append(this.poolStatus(pool));
        }
        for (Map.Entry<String, DatabaseConnectionPool> me : this.trashPools.entrySet()) {
            name = me.getKey();
            pool = me.getValue().getPool();
            sb.append("\n").append("Connections pool to Trash \"" + name + "\" status ").append(this.poolStatus(pool));
        }
        return sb.toString();
    }

    public float getMasterPoolLoad() {
        return this.connectionPool.getLoadRatio();
    }

    private String poolStatus(GenericObjectPool<Connection> connectionPool) {
        return "Idle: " + connectionPool.getNumIdle() + "; Active: " + connectionPool.getNumActive() + "; maxActive: " + connectionPool.getMaxActive() + "; maxIdle: " + connectionPool.getMaxIdle();
    }

    public String getPoolStackTrace() {
        StringBuilder sb = new StringBuilder(100);
        if (this.traceFreq > 0) {
            sb.append("db.trace=").append(this.traceFreq).append(" (trace frequency)\n\n");
            for (Map.Entry e : this.trace.entrySet()) {
                sb.append(e.getKey()).append('\n');
                StackTraceElement[] trace = (StackTraceElement[])e.getValue();
                for (int i = 2; i < trace.length; ++i) {
                    sb.append("\tat " + trace[i]).append('\n');
                }
                sb.append('\n');
            }
        } else {
            sb.append("Pool trace is off. Check db.trace option");
        }
        if (sb.length() == 0) {
            sb.append("No connections to db");
        }
        String result = sb.toString();
        log.info(result);
        return result;
    }

    public Connection getDBConnection(boolean autoCommit) {
        Connection con = null;
        try {
            DatabaseData databaseData = this.getDatabaseData();
            Class.forName(databaseData.dbDriver).getConstructor(new Class[0]).newInstance(new Object[0]);
            con = DriverManager.getConnection(databaseData.dbUrl, databaseData.dbUser, databaseData.dbPswd);
            con.setAutoCommit(autoCommit);
        }
        catch (Exception ex) {
            log.error("error get DB connection", (Throwable)ex);
        }
        return con;
    }

    public Connection getDBConnection() {
        return this.getDBConnection(true);
    }

    public void logConfigure(String log) {
        File logDir = new File("log");
        if (logDir.exists() && logDir.isDirectory()) {
            System.setProperty("log.dir.path", logDir.getAbsolutePath() + File.separator);
            System.setProperty("log4j.configurationFile", log);
            Configurator.reconfigure();
        }
    }

    public DatabaseData getDatabaseData() {
        if (this.databaseData == null) {
            this.databaseData = new DatabaseData();
            this.databaseData.dbDriver = this.get("db.driver", null);
            this.databaseData.dbUrl = this.get("db.url", null);
            this.databaseData.dbUser = this.get("db.user", null);
            this.databaseData.dbPswd = this.get("db.pswd", null);
        }
        return this.databaseData;
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Throwable e) {
            LogManager.getLogger().fatal("error add bouncycastle provider", e);
        }
        log = LogManager.getLogger();
        repMutex = new Object();
    }

    public class DatabaseData {
        private String dbDriver;
        private String dbUrl;
        private String dbUser;
        private String dbPswd;
    }
}

