/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.AddressUtils;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrAddressDao
extends EntityAttrDefaultDao<EntityAttrAddress> {
    final String addressHouseIdName;
    private final String addressTitleName;

    public EntityAttrAddressDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String addressTable, String addressHouseIdName, String addressTitleName) {
        super(con, entityAttrDao, addressTable);
        this.addressHouseIdName = addressHouseIdName;
        this.addressTitleName = addressTitleName;
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `houseId` int(10) unsigned DEFAULT NULL, `flat` varchar(10) DEFAULT NULL, `room` varchar(5) NOT NULL DEFAULT '', `pod` int(10) DEFAULT 0, `floor` int(10) DEFAULT 0, `value` varchar(255) DEFAULT NULL, `comment` varchar(255) DEFAULT NULL, `format_key` varchar(45) DEFAULT '', PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public EntityAttrAddress get(int entityId, int attrSpecId) throws BGException {
        EntityAttrAddress result = null;
        String query = "SELECT " + this.addressHouseIdName + ", pod, floor, flat, room, comment, format_key, " + this.addressTitleName + " FROM " + this.table + "  WHERE " + this.idName() + "=? AND " + this.typeName() + "=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, entityId);
            ps.setInt(2, attrSpecId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = EntityAttrAddress.builder((int)entityId, (int)attrSpecId).setHouseId(rs.getInt(1)).setPod(rs.getInt(2)).setFloor(rs.getInt(3)).setFlat(rs.getString(4)).setRoom(rs.getString(5)).setComment(rs.getString(6)).setFormatKey(rs.getString(7)).setTitle(rs.getString(8)).build();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws BGException {
        EntityAttrAddress address = (EntityAttrAddress)a;
        String query = "INSERT INTO " + this.table + " SET " + this.idName() + "=?, " + this.typeName() + "=?, " + this.addressHouseIdName + "=?, pod=?, floor=?, flat=?, room=?, comment=?, format_key=?, " + this.addressTitleName + "=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, entityId);
            ps.setInt(2, a.getEntitySpecAttrId());
            ps.setInt(3, address.getHouseId());
            ps.setInt(4, address.getPod());
            ps.setInt(5, address.getFloor());
            ps.setString(6, address.getFlat());
            ps.setString(7, address.getRoom() == null ? "" : address.getRoom());
            ps.setString(8, address.getComment());
            ps.setString(9, address.getFormatKey());
            ps.setString(10, address.getTitle());
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    @Override
    protected boolean updateImpl(int entityId, EntityAttrAddress address) throws SQLException, BGException {
        if (address == null) {
            return false;
        }
        if (address.getHouseId() < 0) {
            return this.deleteImpl(entityId, address.getEntitySpecAttrId());
        }
        if (this.get(entityId, address.getEntitySpecAttrId()) != null) {
            String query = "UPDATE " + this.table + " SET " + this.addressHouseIdName + "=?, pod=?, floor=?, flat=?, room=?, comment=?, format_key=?, " + this.addressTitleName + "=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND ( " + this.addressHouseIdName + "<>? OR pod<>? OR floor<>? OR flat<>? OR room<>? OR comment<>? OR format_key<>? OR BINARY " + this.addressTitleName + "<>? )";
            try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
                int parameterIndex = 1;
                psUpdate.setInt(parameterIndex++, address.getHouseId());
                psUpdate.setInt(parameterIndex++, address.getPod());
                psUpdate.setInt(parameterIndex++, address.getFloor());
                psUpdate.setString(parameterIndex++, address.getFlat());
                psUpdate.setString(parameterIndex++, address.getRoom() == null ? "" : address.getRoom());
                psUpdate.setString(parameterIndex++, address.getComment());
                psUpdate.setString(parameterIndex++, address.getFormatKey());
                psUpdate.setString(parameterIndex++, address.getTitle());
                psUpdate.setInt(parameterIndex++, entityId);
                psUpdate.setInt(parameterIndex++, address.getEntitySpecAttrId());
                psUpdate.setInt(parameterIndex++, address.getHouseId());
                psUpdate.setInt(parameterIndex++, address.getPod());
                psUpdate.setInt(parameterIndex++, address.getFloor());
                psUpdate.setString(parameterIndex++, address.getFlat());
                psUpdate.setString(parameterIndex++, address.getRoom());
                psUpdate.setString(parameterIndex++, address.getComment());
                psUpdate.setString(parameterIndex++, address.getFormatKey());
                psUpdate.setString(parameterIndex++, address.getTitle());
                boolean bl = psUpdate.executeUpdate() > 0;
                return bl;
            }
        }
        this.insert(entityId, (EntityAttr)address);
        return true;
    }

    void onUpdate(ServerContext context, Class<?> clazz, int id) throws SQLException, BGException {
        List<House> houseList;
        AddressUtils addressUtils;
        Setup setup;
        block25: {
            setup = context.getSetup();
            addressUtils = new AddressUtils(context);
            try (HouseDao houseDao = new HouseDao(this.con);){
                if (City.class.isAssignableFrom(clazz)) {
                    houseList = houseDao.list(id, 0, 0, 0, 0, null, null);
                    break block25;
                }
                if (Area.class.isAssignableFrom(clazz)) {
                    houseList = houseDao.list(0, id, 0, 0, 0, null, null);
                    break block25;
                }
                if (Street.class.isAssignableFrom(clazz)) {
                    houseList = houseDao.list(id, 0, id, 0, 0, null, null);
                    break block25;
                }
                if (Quarter.class.isAssignableFrom(clazz)) {
                    houseList = houseDao.list(0, 0, 0, id, 0, null, null);
                    break block25;
                }
                if (House.class.isAssignableFrom(clazz)) {
                    houseList = Collections.singletonList(houseDao.get(id));
                    break block25;
                }
                throw new IllegalArgumentException();
            }
        }
        if (Utils.notEmptyCollection(houseList)) {
            try (PreparedStatement ps = this.con.prepareStatement("SELECT pod, floor, flat, room, comment, format_key, " + this.idName() + ", " + this.typeName() + " FROM " + this.table + "  WHERE " + this.addressHouseIdName + "=?");
                 PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET " + this.addressTitleName + "=?  WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");){
                for (House house : houseList) {
                    ps.setInt(1, id);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        EntityAttrAddress attrAddress = new EntityAttrAddress(rs.getInt(7), rs.getInt(8));
                        attrAddress.setPod(rs.getInt(1));
                        attrAddress.setFloor(rs.getInt(2));
                        attrAddress.setFlat(rs.getString(3));
                        attrAddress.setRoom(rs.getString(4));
                        attrAddress.setComment(rs.getString(5));
                        attrAddress.setFormatKey(rs.getString(6));
                        updatePS.setString(1, addressUtils.getAddress((ParameterMap)setup, house, attrAddress));
                        updatePS.setInt(2, attrAddress.getEntityId());
                        updatePS.setInt(3, attrAddress.getEntitySpecAttrId());
                        updatePS.executeUpdate();
                    }
                    rs.close();
                }
            }
        }
    }
}

