/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.job.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.job.common.bean.Job;
import ru.bitel.oss.kernel.job.common.bean.JobTrigger;
import ru.bitel.oss.kernel.job.server.JobRuntime;
import ru.bitel.oss.kernel.job.server.JobScheduler;
import ru.bitel.oss.kernel.job.server.JobTriggerRuntime;

public class JobStore
implements Runnable {
    private static final Logger logger = LogManager.getLogger();
    private final JobScheduler jobScheduler;
    final String name;
    final int moduleId;
    private final String jobTableName;
    private final String jobTriggerTableName;
    private final DefaultServerSetup setup;
    private final Lock readLock;
    private final Lock writeLock;
    private final ConcurrentMap<Long, JobRuntime> jobMap = new ConcurrentHashMap<Long, JobRuntime>();
    private final ConcurrentMap<Long, JobTriggerRuntime> jobTriggerMap = new ConcurrentHashMap<Long, JobTriggerRuntime>();

    public JobStore(DefaultServerSetup setup, JobScheduler jobScheduler, String name, int moduleId) {
        this.jobScheduler = jobScheduler;
        this.setup = setup;
        this.name = name;
        this.moduleId = moduleId;
        this.jobTableName = name + "_job" + (String)(moduleId > 0 ? "_" + moduleId : "");
        this.jobTriggerTableName = name + "_job_trigger" + (String)(moduleId > 0 ? "_" + moduleId : "");
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.init();
        this.jobScheduler.scheduledExecutorService.scheduleWithFixedDelay(this, 10L, 10L, TimeUnit.MINUTES);
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.writeLock.lock();
        try {
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                Statement stmt;
                if (!ServerUtils.tableExists(con, this.jobTableName)) {
                    stmt = con.createStatement();
                    stmt.executeUpdate("CREATE TABLE `" + this.jobTableName + "` ( `id` bigint(20) NOT NULL AUTO_INCREMENT, `group` varchar(255) DEFAULT NULL, `name` varchar(255) DEFAULT NULL, `className` varchar(255) NOT NULL, `persistent` tinyint(4) NOT NULL DEFAULT '0', `concurrent` tinyint(4) NOT NULL DEFAULT '0', `params` text, `version` bigint(20) NOT NULL DEFAULT '1', PRIMARY KEY (`id`), KEY `name` (`group`,`name`))");
                    stmt.close();
                }
                if (!ServerUtils.tableExists(con, this.jobTriggerTableName)) {
                    stmt = con.createStatement();
                    stmt.executeUpdate("CREATE TABLE `" + this.jobTriggerTableName + "` ( `id` bigint(20) NOT NULL AUTO_INCREMENT, `jobId` bigint(20) NOT NULL, `timeFromMillis` bigint(20) NOT NULL, `timeToMillis` bigint(20) NOT NULL, `persistent` tinyint(4) DEFAULT NULL, `type` int(11) NOT NULL, `data` blob, `fireTimePrevMillis` bigint(20) NOT NULL DEFAULT '0', `fireTimeNextMillis` bigint(20) NOT NULL DEFAULT '0', `fireCount` bigint(20) NOT NULL DEFAULT '0', `version` bigint(20) NOT NULL DEFAULT '0', PRIMARY KEY (`id`,`jobId`), KEY `job` (`jobId`), KEY `time` (`timeFromMillis`,`timeToMillis`))");
                    stmt.close();
                }
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void run() {
        this.writeLock.lock();
        try {
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                con.setAutoCommit(false);
                this.moveHistory(con);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void moveHistory(Connection con) throws SQLException {
        Date date = new Date();
        String jobLogTableName = ServerUtils.getMonthTableName(this.name + "_job_log" + (String)(this.moduleId > 0 ? "_" + this.moduleId : ""), date);
        if (!ServerUtils.tableExists(con, jobLogTableName)) {
            Statement stmt = con.createStatement();
            stmt.executeUpdate(" CREATE TABLE `" + jobLogTableName + "` ( `id` bigint(20) NOT NULL AUTO_INCREMENT, `jobId` bigint(20) NOT NULL, `group` varchar(255) DEFAULT NULL, `name` varchar(255) DEFAULT NULL, `className` varchar(255) NOT NULL, `concurrent` tinyint(4) NOT NULL, `params` varchar(255) DEFAULT NULL, `jobTriggerId` bigint(20) NOT NULL, `timeFromMillis` bigint(20) NOT NULL, `timeToMillis` bigint(20) NOT NULL, `persistent` tinyint(4) NOT NULL, `type` tinyint(4) NOT NULL, `data` varchar(255) DEFAULT NULL, `fireTimePrevMillis` bigint(20) NOT NULL, `fireTimeNextMillis` bigint(20) NOT NULL, `fireCount` bigint(20) NOT NULL, PRIMARY KEY (`id`), KEY `job` (`jobId`), KEY `trigger` (`jobTriggerId`), KEY `jobName` (`group`,`name`))");
            stmt.close();
        }
        PreparedStatement insertPS = con.prepareStatement("INSERT INTO " + jobLogTableName + " (jobId, `group`, `name`, className, concurrent, params, jobTriggerId, timeFromMillis, timeToMillis, persistent, type, data, fireTimePrevMillis, fireTimeNextMillis, fireCount) SELECT job.id, job.`group`, job.`name`, job.className, job.concurrent, job.params, trggr.id, trggr.timeFromMillis, trggr.timeToMillis, trggr.persistent, trggr.type, trggr.data, trggr.fireTimePrevMillis, trggr.fireTimeNextMillis, trggr.fireCount FROM `" + this.jobTriggerTableName + "` as trggr LEFT JOIN `" + this.jobTableName + "` as job ON trggr.jobId=job.id WHERE trggr.id=?");
        PreparedStatement deletePS = con.prepareStatement("DELETE FROM `" + this.jobTriggerTableName + "` WHERE id=?");
        PreparedStatement ps = con.prepareStatement("SELECT id FROM `" + this.jobTriggerTableName + "` WHERE timeToMillis!=0 AND ((persistent>0 AND timeToMillis<=fireTimePrevMillis) OR (persistent=0 AND timeToMillis<?)) FOR UPDATE");
        ps.setLong(1, date.getTime());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            long id = rs.getLong(1);
            insertPS.setLong(1, id);
            insertPS.executeUpdate();
            deletePS.setLong(1, id);
            deletePS.executeUpdate();
        }
        rs.close();
        ps.close();
        insertPS.close();
        deletePS.close();
        ps = con.prepareStatement("DELETE job.* FROM `" + this.jobTableName + "` as job LEFT JOIN `" + this.jobTriggerTableName + "` as trggr ON trggr.jobId=job.id WHERE trggr.id IS NULL");
        ps.executeUpdate();
        ps.close();
        con.commit();
    }

    public JobRuntime updateJobRuntime(Long jobId, String className, boolean persistent, boolean concurrent, ParameterMap params, String paramsString, long version) throws Exception {
        JobRuntime jobRuntime = (JobRuntime)this.jobMap.get(jobId);
        Class<?> jobClass = this.loadJobClass(className);
        if (jobRuntime == null) {
            jobRuntime = new JobRuntime(this.jobScheduler, jobId);
            jobRuntime.setJob(jobClass, persistent, concurrent, params, paramsString, version);
            this.jobMap.put(jobId, jobRuntime);
        } else {
            jobRuntime.setJob(jobClass, persistent, concurrent, params, paramsString, version);
        }
        return jobRuntime;
    }

    private Class<?> loadJobClass(String className) throws Exception {
        Class<?> result = null;
        try {
            result = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            result = DynamicClassManager.getInstance().loadClass(className);
        }
        return result;
    }

    public JobTriggerRuntime updateJobTriggerRuntime(JobStore jobStore, JobRuntime jobRuntime, Long jobTriggerId, long timeFromMillis, long timeToMillis, boolean persistent, short type, String data, long fireTimePrevMillis, long fireTimeNextMillis, long fireCount, long version) throws ClassNotFoundException {
        JobTriggerRuntime jobTriggerRuntime = (JobTriggerRuntime)((Object)this.jobTriggerMap.get(jobTriggerId));
        if (jobTriggerRuntime == null) {
            jobTriggerRuntime = new JobTriggerRuntime(this.jobScheduler, jobStore, jobTriggerId, jobRuntime);
            jobTriggerRuntime.setTrigger(timeFromMillis, timeToMillis, persistent, type, data, fireTimePrevMillis, fireTimeNextMillis, fireCount, version);
            this.jobTriggerMap.put(jobTriggerId, jobTriggerRuntime);
        } else {
            jobTriggerRuntime.setTrigger(timeFromMillis, timeToMillis, persistent, type, data, fireTimePrevMillis, fireTimeNextMillis, fireCount, version);
        }
        return jobTriggerRuntime;
    }

    public void load() {
        this.writeLock.lock();
        try {
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                con.setAutoCommit(false);
                this.loadImpl(con);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private long fetchPeriodMillis() {
        return TimeUnit.DAYS.toMillis(3L);
    }

    private void loadImpl(Connection con) throws SQLException, ClassNotFoundException {
        Long id;
        Map.Entry e;
        HashSet<Long> existsJobIds = new HashSet<Long>();
        HashSet<Long> existsTriggerIds = new HashSet<Long>();
        long millis = System.currentTimeMillis();
        PreparedStatement ps = con.prepareStatement("SELECT job.id, job.className, job.persistent, job.concurrent, job.params, job.version, trggr.id, trggr.timeFromMillis, trggr.timeToMillis, trggr.persistent, trggr.type, trggr.data, trggr.fireTimePrevMillis, trggr.fireTimeNextMillis, trggr.fireCount, trggr.version FROM `" + this.jobTableName + "` as job LEFT JOIN `" + this.jobTriggerTableName + "` as trggr ON trggr.jobId=job.id WHERE (trggr.timeFromMillis=0 OR trggr.timeFromMillis<?) AND (trggr.timeToMillis=0 OR ((job.persistent>0 OR trggr.persistent>0 OR trggr.timeToMillis>?) AND trggr.timeToMillis>trggr.fireTimePrevMillis))");
        ps.setLong(1, millis + this.fetchPeriodMillis());
        ps.setLong(2, millis);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            try {
                Long jobId = rs.getLong(1);
                String className = rs.getString(2);
                boolean persistent = rs.getBoolean(3);
                boolean concurrent = rs.getBoolean(4);
                String params = rs.getString(5);
                long version = rs.getLong(6);
                JobRuntime jobRuntime = this.updateJobRuntime(jobId, className, persistent, concurrent, null, params, version);
                existsJobIds.add(jobId);
                Long jobTriggerId = rs.getLong(7);
                long timeFromMillis = rs.getLong(8);
                long timeToMillis = rs.getLong(9);
                boolean persistent2 = rs.getBoolean(10);
                if (rs.wasNull()) {
                    persistent2 = jobRuntime.isPersistent();
                }
                short type = rs.getShort(11);
                String data = rs.getString(12);
                long fireTimePrevMillis = rs.getLong(13);
                long fireTimeNextMillis = rs.getLong(14);
                long fireCount = rs.getLong(15);
                long version2 = rs.getLong(16);
                this.updateJobTriggerRuntime(this, jobRuntime, jobTriggerId, timeFromMillis, timeToMillis, persistent2, type, data, fireTimePrevMillis, fireTimeNextMillis, fireCount, version2);
                existsTriggerIds.add(jobTriggerId);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        rs.close();
        ps.close();
        Iterator iter = this.jobTriggerMap.entrySet().iterator();
        while (iter.hasNext()) {
            e = iter.next();
            id = (Long)e.getKey();
            JobTriggerRuntime triggerRuntime = (JobTriggerRuntime)((Object)e.getValue());
            if (existsTriggerIds.contains(id) && existsJobIds.contains(triggerRuntime.jobRuntime.id)) continue;
            triggerRuntime.cancel();
            iter.remove();
        }
        iter = this.jobMap.entrySet().iterator();
        while (iter.hasNext()) {
            e = iter.next();
            id = (Long)e.getKey();
            if (existsJobIds.contains(id)) continue;
            iter.remove();
        }
    }

    public long fire(ServerContext context, JobTriggerRuntime triggerRuntime, long millis, long count) throws Exception {
        Connection con = context.getConnection();
        PreparedStatement ps = con.prepareStatement("SELECT timeToMillis, fireTimePrevMillis, fireTimeNextMillis, fireCount, version FROM `" + this.jobTriggerTableName + "` WHERE id=? FOR UPDATE");
        ps.setLong(1, triggerRuntime.id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            long fireTimePrevMillis = rs.getLong(2);
            long fireTimeNextMillis = rs.getLong(3);
            long fireCount = rs.getLong(4);
            long version = rs.getLong(5);
            if (fireTimeNextMillis > 0L && triggerRuntime.getFireTimeNextMillis() != fireTimeNextMillis || fireTimePrevMillis >= millis || count > 0L && fireCount >= count || fireTimeNextMillis / 50L > millis / 50L) {
                logger.debug("JobTrigger fired on other application");
                ps.close();
                triggerRuntime.setTrigger(fireTimePrevMillis, fireTimeNextMillis, fireCount, version);
                return -1L;
            }
        } else {
            rs.close();
            ps.close();
            logger.info("JobTrigger not exist");
            return 0L;
        }
        rs.close();
        ps.close();
        long result = this.fireImpl(con, triggerRuntime, millis);
        if (result > 0L) {
            ps = con.prepareStatement("UPDATE `" + this.jobTriggerTableName + "` SET fireTimePrevMillis=?, fireTimeNextMillis=?, fireCount=fireCount+1 WHERE id=? AND (@fireCount:=fireCount) IS NOT NULL");
            ps.setLong(1, millis);
            ps.setLong(2, result);
            ps.setLong(3, triggerRuntime.id);
            ps.executeUpdate();
        } else {
            ps = con.prepareStatement("UPDATE `" + this.jobTriggerTableName + "` SET timeToMillis=?, fireTimePrevMillis=?, fireTimeNextMillis=?, fireCount=fireCount+1 WHERE id=? AND (@fireCount:=fireCount) IS NOT NULL");
            ps.setLong(1, millis);
            ps.setLong(2, millis);
            ps.setLong(3, result);
            ps.setLong(4, triggerRuntime.id);
            ps.executeUpdate();
        }
        ps.close();
        context.commit();
        return result;
    }

    private long fireImpl(Connection con, JobTriggerRuntime triggerRuntime, long millis) throws Exception {
        if (!triggerRuntime.jobRuntime.isConcurrent()) {
            PreparedStatement ps = con.prepareStatement("SELECT * FROM `" + this.jobTableName + "` WHERE id=? FOR UPDATE");
            ps.setLong(1, triggerRuntime.id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                // empty if block
            }
            rs.close();
            ps.close();
        }
        long result = triggerRuntime.fire(millis);
        return result;
    }

    public Job getJob(Connection con, Long jobId) throws BGException {
        Job result = null;
        try (PreparedStatement ps = con.prepareStatement("SELECT * FROM " + this.jobTableName + " as job WHERE job.id=?");){
            ps.setLong(1, jobId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String group = rs.getString("group");
                    String name = rs.getString("name");
                    String className = rs.getString("className");
                    boolean persistent = rs.getBoolean("persistent");
                    boolean concurrent = rs.getBoolean("concurrent");
                    String params = rs.getString("params");
                    long version = rs.getLong("version");
                    result = new Job(jobId.longValue(), group, name, className, concurrent, persistent, params, version);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public JobTrigger getJobTrigger(Connection con, Long jobTriggerId) throws BGException {
        JobTrigger result = null;
        try (PreparedStatement ps = con.prepareStatement("SELECT * FROM " + this.jobTriggerTableName + " as jobTrigger WHERE jobTrigger.id=?");){
            ps.setLong(1, jobTriggerId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getJobTriggerFromRs(rs);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private JobTrigger getJobTriggerFromRs(ResultSet rs) throws SQLException {
        JobTrigger result = new JobTrigger();
        result.setId(rs.getLong("id"));
        result.setJobId(rs.getLong("jobId"));
        result.setTimeFrom(new Date(rs.getLong("timeFromMillis")));
        result.setTimeTo(new Date(rs.getLong("timeToMillis")));
        result.setPersistent(rs.getBoolean("persistent"));
        result.setType(rs.getShort("type"));
        result.setData(rs.getString("data"));
        result.setVersion(rs.getLong("version"));
        result.setFireCount(rs.getLong("fireCount"));
        result.setFireTimePrev(new Date(rs.getLong("fireTimePrevMillis")));
        result.setFireTimeNext(new Date(rs.getLong("fireTimeNextMillis")));
        return result;
    }

    public long updateJob(Connection con, Job job) throws BGException {
        return this.updateJob(con, job.getId(), job.getClassName(), job.isPersistent(), job.isConcurrent(), job.getParams());
    }

    public long updateJob(Connection con, long jobId, String className, boolean persistent, boolean concurrent, String params) throws BGException {
        boolean psInsert = jobId <= 0L;
        try (PreparedStatement ps = con.prepareStatement((psInsert ? "INSERT INTO " : "UPDATE ") + this.jobTableName + " SET className=?, persistent=?, concurrent=?, params=?, version=" + (psInsert ? "1" : "version+1 WHERE id=? AND version IS NOT NULL"), 1);){
            ps.setString(1, className);
            ps.setBoolean(2, persistent);
            ps.setBoolean(3, concurrent);
            ps.setString(4, params);
            if (!psInsert) {
                ps.setLong(5, jobId);
            }
            if (ps.executeUpdate() == 0) {
                throw new BGException("\u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
            }
            if (psInsert) {
                jobId = ServerUtils.lastInsertId(con);
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return jobId;
    }

    public long updateJobTrigger(Connection con, JobTrigger jobTrigger) throws SQLException, BGException, ClassNotFoundException {
        return this.updateJobTrigger(con, jobTrigger.getJobId(), jobTrigger.getId(), jobTrigger.getTimeFrom().getTime(), jobTrigger.getTimeTo().getTime(), jobTrigger.isPersistent(), jobTrigger.getType(), jobTrigger.getData());
    }

    public long updateJobTrigger(Connection con, long jobId, long jobTriggerId, long timeFromMillis, long timeToMillis, boolean persistent, short type, String data) throws SQLException, BGException, ClassNotFoundException {
        PreparedStatement ps;
        if (jobTriggerId > 0L) {
            ps = con.prepareStatement("UPDATE " + this.jobTriggerTableName + " SET timeFromMillis=?, timeToMillis=?, persistent=?, type=?, data=?, version=version+1 WHERE id=? AND (@version:=version) IS NOT NULL AND (@fireTimePrevMillis:=fireTimePrevMillis) IS NOT NULL AND (@fireTimeNextMillis:=fireTimeNextMillis) IS NOT NULL AND (@fireCount:=fireCount) IS NOT NULL");
            ps.setLong(1, timeFromMillis);
            ps.setLong(2, timeToMillis);
            ps.setBoolean(3, persistent);
            ps.setInt(4, type);
            ps.setString(5, data);
            ps.setLong(6, jobTriggerId);
            if (ps.executeUpdate() == 0) {
                jobTriggerId = 0L;
            }
            ps.close();
        }
        if (jobTriggerId <= 0L) {
            ps = con.prepareStatement("INSERT INTO " + this.jobTriggerTableName + " (jobId, timeFromMillis, timeToMillis, persistent, type, data, fireCount, version) VALUES (?,?,?,?,?,?,0,1)", 1);
            ps.setLong(1, jobId);
            ps.setLong(2, timeFromMillis);
            ps.setLong(3, timeToMillis);
            ps.setBoolean(4, persistent);
            ps.setInt(5, type);
            ps.setString(6, data);
            ps.executeUpdate();
            jobTriggerId = ServerUtils.lastInsertId(ps);
            ps.close();
        }
        return jobTriggerId;
    }

    public JobTrigger getJobTriggerByJobId(Connection con, long jobId) throws BGException {
        JobTrigger result = null;
        try (PreparedStatement ps = con.prepareStatement("SELECT * FROM " + this.jobTriggerTableName + " as jobTrigger WHERE jobId=?");){
            ps.setLong(1, jobId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getJobTriggerFromRs(rs);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean deleteJob(Connection con, long jobId) throws BGException {
        boolean result;
        try (PreparedStatement psDelete = con.prepareStatement("DELETE FROM " + this.jobTableName + " WHERE id=?");){
            psDelete.setLong(1, jobId);
            result = psDelete.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean deleteJobTrigger(Connection con, long jobId) throws BGException {
        boolean result;
        try (PreparedStatement psDelete = con.prepareStatement("DELETE FROM " + this.jobTriggerTableName + " WHERE jobId=?");){
            psDelete.setLong(1, jobId);
            result = psDelete.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long schedule(Class<?> clazz, ParameterMap params, String year, String month, String dayOfMonth, String dayOfWeek, String hour, String minute, String second) throws BGException {
        Lock lock = this.readLock;
        lock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            if (Utils.notBlankString((String)year)) {
                sb.append("year=").append(year).append('\n');
            }
            if (Utils.notBlankString((String)month)) {
                sb.append("month=").append(month).append('\n');
            }
            if (Utils.notBlankString((String)dayOfMonth)) {
                sb.append("dayOfMonth=").append(dayOfMonth).append('\n');
            }
            if (Utils.notBlankString((String)dayOfWeek)) {
                sb.append("dayOfWeek=").append(dayOfWeek).append('\n');
            }
            if (Utils.notBlankString((String)hour)) {
                sb.append("hour=").append(hour).append('\n');
            }
            if (Utils.notBlankString((String)minute)) {
                sb.append("minute=").append(minute).append('\n');
            }
            if (Utils.notBlankString((String)second)) {
                sb.append("second=").append(second).append('\n');
            }
            long l = this.scheduleImpl(clazz, params, true, false, System.currentTimeMillis(), 0L, (short)1, sb.toString());
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long schedule(Class<?> clazz, ParameterMap params, long millis) throws BGException {
        Lock lock = this.readLock;
        lock.lock();
        try {
            long l = this.scheduleImpl(clazz, params, true, false, millis, 0L, (short)0, null);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(long jobId) {
        ServerContext context = (ServerContext)ServerContext.get();
        Connection con = context != null ? context.getConnection() : this.setup.getDBConnectionFromPool();
        Lock lock = this.readLock;
        lock.lock();
        try {
            if (context == null) {
                con.setAutoCommit(false);
            }
            this.deleteJob(con, jobId);
            this.deleteJobTrigger(con, jobId);
            if (context == null) {
                con.commit();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            lock.unlock();
            if (context == null) {
                ServerUtils.closeConnection(con);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private long scheduleImpl(Class<?> clazz, ParameterMap params, boolean persistent, boolean concurrent, long timeFromMillis, long timeToMillis, short triggerType, String triggerData) throws BGException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 9[FORLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

