/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.mps.common.service.MPSService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class PaymentSystemPanel
extends BGUPanel {
    private JPanel cardPanel;
    private ParamTableName paramTableName = new ParamTableName();
    private JTextArea paymentSystemConfig = new JTextArea(20, 20);
    private BGUList<KeyValue> paymenSystemList = new BGUList();
    private List<ParamData> paramDataList = Arrays.asList(new ParamData("title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new ParamData("mode", "\u0420\u0435\u0436\u0438\u043c \u0440\u0430\u0431\u043e\u0442\u044b (\u0432\u043a\u043b./\u0432\u044b\u043a\u043b.)"), new ParamData("protocol", "\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b"), new ParamData("protocol.ext", "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430)"), new ParamData("login", "\u041b\u043e\u0433\u0438\u043d"), new ParamData("passw", "\u041f\u0430\u0440\u043e\u043b\u044c"), new ParamData("secret", "\u0421\u0435\u043a\u0440\u0435\u0442"), new ParamData("secret.response", "\u0421\u0435\u043a\u0440\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430"), new ParamData("pid", "ID \u0442\u0438\u043f\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (\u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430)"), new ParamData("search.multi", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043c\u0443\u043b\u044c\u0442\u0438\u043f\u043e\u0438\u0441\u043a"), new ParamData("comment", "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new ParamData("request.encoding", "\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430"), new ParamData("response.encoding", "\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430"), new ParamData("paytime", ""), new ParamData("cert", "\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0443"), new ParamData("min.summ", "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430"), new ParamData("max.summ", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430"), new ParamData("privatekey.alias", "\u0410\u043b\u0438\u0430\u0441 \u043f\u0440\u0438\u0432\u0430\u0442\u043d\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430"), new ParamData("register.pattern", ""), new ParamData("register.patternOrder", ""), new ParamData("register.timeFormat", ""), new ParamData("register.checkAccount", ""), new ParamData("mode", ""), new ParamData("numberPattern", ""));

    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getListPanel(), (Component)this.getCardPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getListPanel() {
        this.paymenSystemList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    PaymentSystemPanel.this.performAction("edit");
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.paymenSystemList, (int)200, (int)200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getCardPanel() {
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.add((Component)new JPanel(), "empty");
        this.cardPanel.add((Component)this.getEditorPanel(), "editor");
        return this.cardPanel;
    }

    private JPanel getEditorPanel() {
        BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.SAVE, BGButtonPanel.CLOSE});
        buttonPanel.addActionListener(e -> {
            if (BGButtonPanel.CLOSE.getActionCommand().equals(e.getActionCommand())) {
                this.paymenSystemList.setEnabled(true);
                ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "empty");
            } else if (BGButtonPanel.SAVE.getActionCommand().equals(e.getActionCommand())) {
                try {
                    ((MPSService)((ClientContext)this.getContext()).getWebService(MPSService.class)).updateMPSSystemConfig(((KeyValue)this.paymenSystemList.getSelectedValue()).getKey(), this.paymentSystemConfig.getText());
                    this.paymenSystemList.setEnabled(true);
                    ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "empty");
                    this.performAction("refresh");
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        JLabel titleLabel = new JLabel("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
        titleLabel.setFont(titleLabel.getFont().deriveFont(titleLabel.getFont().getSize2D() * 1.5f));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)titleLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 15, 5, 5), 0, 0));
        panel.add((Component)this.getParamTablePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getConfigPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getParamTablePanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.paramTableName));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                ParamData paramData;
                if (event.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(event) && (paramData = (ParamData)PaymentSystemPanel.this.paramTableName.getSelectedRow()) != null) {
                    new ParamEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", paramData).open();
                    PaymentSystemPanel.this.updateConfig(paramData);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)200, (int)400), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getConfigPanel() {
        this.paymentSystemConfig.setMargin(new Insets(3, 3, 3, 3));
        this.paymentSystemConfig.setEditable(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.paymentSystemConfig, (int)200, (int)200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void updateConfig(ParamData paramData) {
        String paramName = "mps." + ((KeyValue)this.paymenSystemList.getSelectedValue()).getKey() + "." + paramData.getName() + "=";
        List config = Utils.toList((String)this.paymentSystemConfig.getText(), (String)"\n");
        boolean update = false;
        for (int index = 0; index < config.size(); ++index) {
            String line = (String)config.get(index);
            if (!line.startsWith(paramName)) continue;
            if (paramData.getValue() == null) {
                config.remove(index);
            } else {
                config.set(index, paramName + paramData.getValue());
            }
            update = true;
            break;
        }
        if (!update && paramData.getValue() != null) {
            config.add(paramName + paramData.getValue());
        }
        this.paymentSystemConfig.setText(config.stream().collect(Collectors.joining("\n")));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.paymenSystemList.setData(((MPSService)((ClientContext)this.getContext()).getWebService(MPSService.class)).getMPSSystemList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (!this.paymenSystemList.isEnabled()) {
                return;
            }
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (!this.paymenSystemList.isEnabled()) {
                return;
            }
            KeyValue keyValue = (KeyValue)this.paymenSystemList.getSelectedValue();
            if (keyValue == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            String key = keyValue.getKey();
            String config = ((MPSService)((ClientContext)this.getContext()).getWebService(MPSService.class)).getMPSSystemConfig(key);
            String[] configLines = config.split("\n");
            this.paramDataList.forEach(a -> {
                for (String line : configLines) {
                    String name = "mps." + key + "." + a.getName() + "=";
                    if (!line.startsWith(name)) continue;
                    a.setValue(line.substring(name.length()));
                    return;
                }
                a.setValue("");
            });
            this.paramTableName.setPrefix("mps." + key + ".");
            this.paramTableName.setData(this.paramDataList);
            this.paymentSystemConfig.setText(config);
            this.paymenSystemList.setEnabled(false);
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "editor");
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (!this.paymenSystemList.isEnabled()) {
                return;
            }
            KeyValue keyValue = (KeyValue)this.paymenSystemList.getSelectedValue();
            if (keyValue == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete((Object)keyValue.getGuiTitle())) {
                ((MPSService)((ClientContext)this.getContext()).getWebService(MPSService.class)).deleteMPSSystemConfig(keyValue.getKey());
                this.performAction("refresh");
            }
        });
    }

    class ParamTableName
    extends BGTableModel<ParamData> {
        private String prefix;

        public ParamTableName() {
            super(ParamTableName.class.getName());
            this.prefix = "";
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043b\u044e\u0447", 200, 250, 300, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, 300, 400, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(ParamData paramData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("name".equals(identifier)) {
                return this.prefix + paramData.getName();
            }
            return super.getValue((Object)paramData, column);
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public class ParamData {
        private String name;
        private String title;
        private String value;

        public ParamData(String name, String title) {
            this.name = name;
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class ParamEditorDialog
    extends BGEditorDialog<ParamData> {
        private JTextField field;
        private JCheckBox deleteParam;

        public ParamEditorDialog(String title, ParamData data) {
            super(title, (Object)data);
            this.field = new JTextField(50);
            this.deleteParam = new JCheckBox("\u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
        }

        public void doDialogPanel() {
            JLabel label = new JLabel(((ParamData)this.data).getTitle());
            label.setFont(label.getFont().deriveFont(1.3f * label.getFont().getSize2D()));
            this.panel.add((Component)label, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.field, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.deleteParam, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            label.setText(((ParamData)this.data).getTitle());
            this.field.setText(((ParamData)this.data).getValue());
        }

        public boolean doApply() throws Exception {
            ((ParamData)this.data).setValue(this.deleteParam.isSelected() ? null : this.field.getText());
            return true;
        }
    }
}

