/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.notification.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.notification.common.bean.NotificationData;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.PeriodWithTime;

public class NotificationDao
extends AbstractIdDao<NotificationData> {
    public NotificationDao(Connection con) {
        super(con, 0, "notification_data");
    }

    public List<NotificationData> list(int contractId) throws BGException {
        return this.list("contract_id=?", "", new Object[]{contractId});
    }

    protected NotificationData getFromRS(ResultSet rs) throws SQLException, BGException {
        NotificationData notificationData = new NotificationData();
        notificationData.setId(rs.getInt("id"));
        notificationData.setContractId(rs.getInt("contract_id"));
        notificationData.setTitle(rs.getString("subject"));
        notificationData.setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        notificationData.setData(rs.getString("data"));
        notificationData.setHandlerClassName(rs.getString("handler_class_name"));
        return notificationData;
    }

    protected void updateImpl(NotificationData notificationData) throws BGException, SQLException {
        Objects.requireNonNull(notificationData);
        boolean update = notificationData.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET contract_id=?, subject=?, date_from=?, date_to=?, data=?, handler_class_name=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, notificationData.getContractId());
            ps.setString(index++, notificationData.getTitle());
            PeriodWithTime period = notificationData.getPeriod();
            if (period == null) {
                period = new PeriodWithTime();
            }
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)period.getLocalDateTimeFrom()));
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)period.getLocalDateTimeTo()));
            ps.setString(index++, notificationData.getData());
            ps.setString(index++, notificationData.getHandlerClassName());
            if (update) {
                ps.setInt(index++, notificationData.getId());
            }
            ps.executeUpdate();
            if (!update) {
                notificationData.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
    }
}

