/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sbpilot.common.bean;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public interface JsoneableModel {
    public static void getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null && type.getSuperclass() != Object.class) {
            JsoneableModel.getAllFields(fields, type.getSuperclass());
        }
    }

    default public String toJson(int indent) {
        ArrayList<Field> fields = new ArrayList<Field>();
        JsoneableModel.getAllFields(fields, this.getClass());
        JSONObject dict = new JSONObject();
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                dict.put(field.getName(), field.get(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dict.toString(indent);
    }

    default public String toJson() {
        return this.toJson(0);
    }

    public static void setField(Object obj, Class<?> clazz, String fieldName, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz == Object.class) {
                throw e;
            }
            JsoneableModel.setField(obj, superClazz, fieldName, value);
        }
    }

    default public void fromJson(String json) {
        JSONObject dict = new JSONObject(json);
        for (Map.Entry fieldnv : dict.toMap().entrySet()) {
            String fieldName = (String)fieldnv.getKey();
            Object fieldValue = fieldnv.getValue();
            try {
                JsoneableModel.setField(this, this.getClass(), fieldName, fieldValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

