/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.task;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.softline.common.SoftLineUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;

public class SubscriptionSuspendDailyTask
extends TaskBase {
    private final Logger logger = LogManager.getLogger();
    private SoftLineSubscriptionService subscriptionService;

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        for (SoftLineSubscription subscription : this.getActiveSubscriptions()) {
            if (!SoftLineUtils.checkTodayDate((Date)subscription.getEndDate())) continue;
            try {
                this.logger.info("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438: [subscriptionId=" + subscription.getId() + ", productId=" + subscription.getProductId() + "]");
                this.subscriptionService.subscriptionPause(subscription, subscription.getSuspendReason());
            }
            catch (BGException e) {
                this.getLogger().error(e.getMessage());
            }
        }
    }

    private List<SoftLineSubscription> getActiveSubscriptions() {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        try {
            this.subscriptionService = (SoftLineSubscriptionService)serverContext.getService(SoftLineSubscriptionService.class, this.moduleId);
            return this.subscriptionService.searchSubscriptions(null, null, -1, -1, SoftLineSubscriptionStatus.ACTIVE, -1).getList();
        }
        catch (BGException e) {
            this.getLogger().error(e.getMessage());
            return Collections.emptyList();
        }
    }

    public String getDescription() {
        return null;
    }
}

