/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.sorm.common.bean.Ratio;
import ru.bitel.bgbilling.modules.sorm.common.bean.RatioDescription;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.ListItem;

public class SormRatioPanel
extends BGPanel {
    private final JPanel sormTypes;
    private BGUTable table;
    private BGTableModel<Ratio> tableModel;
    private final BGControlPanelListSelect listSelect = new BGControlPanelListSelect(true);
    private final String infoLabelText;

    public SormRatioPanel(String infoLabelText) {
        this.infoLabelText = infoLabelText;
        this.sormTypes = this.sormTypesPanel();
        this.add(this.getTypesRatioPanel());
    }

    private JPanel sormTypesPanel() {
        JPanel listSelectionPanel = new JPanel(new GridBagLayout());
        listSelectionPanel.setVisible(false);
        BGButtonPanelOkCancel buttonPanel = new BGButtonPanelOkCancel();
        buttonPanel.getButtonOk().addActionListener(e -> {
            Ratio ratio = (Ratio)this.tableModel.getSelectedRow();
            if (ratio != null) {
                final int id = Utils.parseInt((String)ClientUtils.getIdFromList((JList)this.listSelect.getList()), (int)-1);
                final String title = ((BGUListItem)this.listSelect.getList().getSelectedValue()).getTitle();
                ratio.setRatioDescription(new RatioDescription(){

                    public int getCode() {
                        return id;
                    }

                    public String getCodeStr() {
                        return String.valueOf(id);
                    }

                    public String getDescription() {
                        return title;
                    }
                });
                buttonPanel.getParent().setVisible(false);
                this.table.setEnabled(true);
            }
        });
        buttonPanel.getButton(BGButtonPanel.CANCEL).addActionListener(e -> {
            buttonPanel.getParent().setVisible(false);
            this.table.setEnabled(true);
        });
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        listSelectionPanel.add((Component)this.listSelect, constraints);
        listSelectionPanel.add((Component)buttonPanel, constraints);
        return listSelectionPanel;
    }

    private JPanel getTypesRatioPanel() {
        this.tableModel = new BGTableModel<Ratio>("typesRatio"){

            protected void initColumns() {
                this.addColumn("ID", -1, 30, -1, "id", true);
                this.addColumn("\u0422\u0438\u043f", -1, 600, -1, "title", true);
                this.addColumn("C\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435", -1, 270, -1, "comboBox", false);
            }

            public Object getValue(Ratio val, int column) throws BGException {
                return column == 2 ? val.getRatioDescription().getDescription() : super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    SormRatioPanel.this.showSelectList();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        Dimension dimension = new Dimension(900, 200);
        scrollPane.setPreferredSize(dimension);
        scrollPane.setMaximumSize(dimension);
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.infoLabelText), constraints);
        panel.add((Component)scrollPane, constraints);
        panel.add((Component)this.sormTypes, new GridBagConstraints(constraints.gridx, constraints.gridy, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void showSelectList() {
        this.listSelect.setListItemSelected(false);
        this.table.setEnabled(false);
        this.sormTypes.setVisible(true);
    }

    public void setDataTable(List<Ratio> items) {
        this.tableModel.setData(items);
    }

    public void setDataSelectionList(List<ListItem> list) {
        ClientUtils.buildList((JList)this.listSelect.getList(), list);
    }

    public List<Ratio> getRatioList() {
        return this.tableModel.getRows();
    }
}

