/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class SormProjectDao
extends AbstractIdDao<SormProject> {
    public SormProjectDao(Connection connection, int mid) {
        super(connection, mid, "sorm_projects");
    }

    public List<SormProject> getList() throws BGException {
        ArrayList<SormProject> projects = new ArrayList<SormProject>();
        String query = "SELECT * FROM " + this.tableName;
        try (Statement statement = this.con.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            while (resultSet.next()) {
                projects.add(this.getFromRS(resultSet));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return projects;
    }

    protected void updateImpl(SormProject sormProject) throws BGException, SQLException {
        String set = " SET title=?, comment=?, user_id=?, config=?, project_type=?, isEnable=?, last_modify_date=NOW()";
        String query = sormProject.getId() <= 0 ? "INSERT INTO " + this.tableName + set + ", create_date=NOW()" : "UPDATE " + this.tableName + set + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, sormProject.getTitle());
            ps.setString(index++, sormProject.getComment());
            ps.setInt(index++, sormProject.getUserId());
            ps.setString(index++, sormProject.getConfig());
            ps.setInt(index++, sormProject.getProjectType());
            ps.setInt(index++, sormProject.isEnable() ? 1 : 0);
            if (sormProject.getId() > 0) {
                ps.setInt(index, sormProject.getId());
            }
            ps.executeUpdate();
            if (sormProject.getId() <= 0) {
                sormProject.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected SormProject getFromRS(ResultSet rs) throws SQLException, BGException {
        SormProject sormProject = new SormProject();
        sormProject.setId(rs.getInt("id"));
        sormProject.setTitle(rs.getString("title"));
        sormProject.setComment(rs.getString("comment"));
        sormProject.setUserId(rs.getInt("user_id"));
        sormProject.setConfig(rs.getString("config"));
        sormProject.setCreateDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("create_date")));
        sormProject.setLastModifyDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("last_modify_date")));
        sormProject.setProjectType(rs.getInt("project_type"));
        int enable = rs.getInt("isEnable");
        sormProject.setEnable(enable == 1);
        return sormProject;
    }

    public List<SormProject> getActiveSormProject() throws BGException {
        ArrayList<SormProject> activeProjects = new ArrayList<SormProject>();
        String query = "SELECT * FROM " + this.tableName + " WHERE isEnable=1";
        try (Statement statement = this.con.createStatement();){
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                activeProjects.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return activeProjects;
    }
}

